/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product;

import com.jidesoft.grid.AbstractRow;
import com.jidesoft.grid.DefaultExpandableRow;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.TreeTable;
import com.jidesoft.grid.TreeTableModel;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.esa.beam.framework.datamodel.FlagCoding;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.ProductData;

public class ProductMetadataTable
extends TreeTable {
    public static final int NAME_COL_INDEX = 0;
    public static final int VALUE_COL_INDEX = 1;
    public static final int TYPE_COL_INDEX = 2;
    public static final int UNIT_COL_INDEX = 3;
    public static final int DESCR_COL_INDEX = 4;
    private static final String[] COLUMN_NAMES = new String[]{"Name", "Value", "Type", "Unit", "Description"};
    private static final int[] COLUMN_WIDTHS = new int[]{180, 180, 50, 40, 200};
    private static final int _DEFAULT_FONT_SIZE = 11;
    private static final Color _numberValueColor = new Color(0, 0, 120);
    private static final Color _textValueColor = new Color(0, 120, 0);
    private static Font _fixedFont;
    private static Font _plainFont;
    private static Font _italicFont;
    MetadataElement rootElement;

    public ProductMetadataTable(MetadataElement rootElement) {
        this.rootElement = rootElement;
        ProductMetadataTable.initFonts();
        this.setModel((TableModel)((Object)new MDTableModel(rootElement)));
        this.getTableHeader().setReorderingAllowed(false);
        for (int i = 0; i < COLUMN_WIDTHS.length; ++i) {
            TableColumn column = this.getColumnModel().getColumn(i);
            column.setPreferredWidth(COLUMN_WIDTHS[i]);
        }
    }

    public MetadataElement getMetadataElement() {
        return this.rootElement;
    }

    public boolean isHexadecimal() {
        return this.getMetadataElement() instanceof FlagCoding;
    }

    private static boolean isNumericAttribute(MetadataAttribute attribute) {
        return !(attribute.getData() instanceof ProductData.ASCII) && !(attribute.getData() instanceof ProductData.UTC);
    }

    private static void initFonts() {
        if (_fixedFont == null) {
            FontUIResource resource = MetalLookAndFeel.getUserTextFont();
            if (resource != null) {
                _fixedFont = new Font("Courier", 0, resource.getSize());
                _plainFont = resource.deriveFont(0);
                _italicFont = resource.deriveFont(2);
            } else {
                _fixedFont = new Font("Courier", 0, 11);
                _plainFont = new Font("SansSerif", 0, 11);
                _italicFont = new Font("SansSerif", 2, 11);
            }
        }
    }

    static class MDAttributeRow
    extends AbstractRow {
        MetadataAttribute attribute;
        int index;

        MDAttributeRow(MetadataAttribute attribute, int index) {
            this.attribute = attribute;
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public MetadataAttribute getAttribute() {
            return this.attribute;
        }

        public Object getValueAt(int column) {
            if (column == 0) {
                if (this.index == -1) {
                    return this.attribute.getName();
                }
                return this.attribute.getName() + "." + this.index;
            }
            if (column == 1) {
                if (this.index == -1) {
                    return this.attribute.getData().getElemString();
                }
                return this.attribute.getData().getElemStringAt(this.index);
            }
            if (column == 2) {
                return this.attribute.getData().getTypeString();
            }
            if (column == 3) {
                return this.attribute.getUnit() != null ? this.attribute.getUnit() : "";
            }
            if (column == 4) {
                return this.attribute.getDescription() != null ? this.attribute.getDescription() : "";
            }
            return "";
        }
    }

    static class MDElementRow
    extends DefaultExpandableRow {
        private MetadataElement element;

        MDElementRow(MetadataElement element) {
            this.element = element;
        }

        public MetadataElement getElement() {
            return this.element;
        }

        public Object getValueAt(int i) {
            if (i == 0) {
                return this.element.getName();
            }
            if (i == 1) {
                return "";
            }
            if (i != 2 && i != 3 && i == 4) {
                return this.element.getDescription() != null ? this.element.getDescription() : "";
            }
            return "";
        }

        public List getChildren() {
            List<Row> children = this._children;
            if (children == null) {
                children = MDTableModel.createRowList(this.element);
                this.setChildren(children);
            }
            return children;
        }

        public void setChildren(List children) {
            for (Object child : children) {
                ((Row)child).setParent((Expandable)this);
            }
            super.setChildren(children);
        }
    }

    static class MDTableModel
    extends TreeTableModel {
        private final MetadataElement rootElement;

        public MDTableModel(MetadataElement rootElement) {
            this.rootElement = rootElement;
            this.setOriginalRows(MDTableModel.createRowList(rootElement));
        }

        public static List<Row> createRowList(MetadataElement rootElement) {
            int i;
            ArrayList<Row> rowList = new ArrayList<Row>(10);
            for (i = 0; i < rootElement.getNumAttributes(); ++i) {
                MetadataAttribute attribute = rootElement.getAttributeAt(i);
                if (!ProductMetadataTable.isNumericAttribute(attribute) || attribute.getData().isScalar()) {
                    rowList.add((Row)new MDAttributeRow(attribute, -1));
                    continue;
                }
                int j = 0;
                while ((long)j < attribute.getNumDataElems()) {
                    rowList.add((Row)new MDAttributeRow(attribute, j));
                    ++j;
                }
            }
            for (i = 0; i < rootElement.getNumElements(); ++i) {
                MetadataElement element = rootElement.getElementAt(i);
                rowList.add((Row)new MDElementRow(element));
            }
            return rowList;
        }

        public MetadataElement getMetadataElement() {
            return this.rootElement;
        }

        public String getColumnName(int col) {
            return COLUMN_NAMES[col];
        }

        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }
    }
}

