/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.ui.BasicView;
import org.esa.beam.framework.ui.PopupMenuHandler;
import org.esa.beam.framework.ui.product.ProductMetadataTable;
import org.esa.beam.framework.ui.product.ProductNodeView;

public class ProductMetadataView
extends BasicView
implements ProductNodeView {
    private ProductMetadataTable _metadataTable;
    private JMenuItem expandMenuItem;
    private JMenuItem collapseMenuItem;

    public ProductMetadataView(MetadataElement metadataElement) {
        this._metadataTable = new ProductMetadataTable(metadataElement);
        this._metadataTable.addMouseListener(new PopupMenuHandler(this));
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane((Component)((Object)this._metadataTable)), "Center");
        this.expandMenuItem = new JMenuItem(new ExpandAllAction());
        this.collapseMenuItem = new JMenuItem(new CollapseAllAction());
    }

    public Product getProduct() {
        return this.getMetadataElement().getProduct();
    }

    public MetadataElement getMetadataElement() {
        return this._metadataTable.getMetadataElement();
    }

    public ProductMetadataTable getMetadataTable() {
        return this._metadataTable;
    }

    @Override
    public ProductNode getVisibleProductNode() {
        return this.getMetadataElement();
    }

    @Override
    public JPopupMenu createPopupMenu(Component component) {
        JPopupMenu popupMenu = new JPopupMenu();
        if (this.getCommandUIFactory() != null) {
            this.getCommandUIFactory().addContextDependentMenuItems("metadata", popupMenu);
        }
        popupMenu.add(this.expandMenuItem);
        popupMenu.add(this.collapseMenuItem);
        return popupMenu;
    }

    @Override
    public JPopupMenu createPopupMenu(MouseEvent event) {
        return null;
    }

    @Override
    public void dispose() {
        this._metadataTable = null;
        super.dispose();
    }

    private class ExpandAllAction
    extends AbstractAction {
        public ExpandAllAction() {
            super("Expand All");
            this.putValue("MnemonicKey", 69);
            this.putValue("ShortDescription", "Expands all tree nodes.");
        }

        @Override
        public boolean isEnabled() {
            ProductMetadataTable metadataTable = ProductMetadataView.this.getMetadataTable();
            return metadataTable.isExpandAllAllowed();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProductMetadataTable metadataTable = ProductMetadataView.this.getMetadataTable();
            metadataTable.expandAll();
        }
    }

    private class CollapseAllAction
    extends AbstractAction {
        public CollapseAllAction() {
            super("Collapse All");
            this.putValue("MnemonicKey", 67);
            this.putValue("ShortDescription", "Collapses all tree nodes.");
        }

        @Override
        public boolean isEnabled() {
            ProductMetadataTable metadataTable = ProductMetadataView.this.getMetadataTable();
            return metadataTable.isExpandAllAllowed();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProductMetadataTable metadataTable = ProductMetadataView.this.getMetadataTable();
            metadataTable.collapseAll();
        }
    }
}

