/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glayer.CollectionLayer;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.LayerFilter;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.glayer.LayerTypeRegistry;
import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glayer.support.LayerUtils;
import com.bc.ceres.glevel.MultiLevelSource;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.ImageInfo;
import org.esa.beam.framework.datamodel.Mask;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductNodeGroup;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.VectorDataNode;
import org.esa.beam.framework.ui.product.ProductSceneView;
import org.esa.beam.framework.ui.product.VectorDataCollectionLayerType;
import org.esa.beam.framework.ui.product.VectorDataLayer;
import org.esa.beam.framework.ui.product.VectorDataLayerFilterFactory;
import org.esa.beam.framework.ui.product.VectorDataLayerType;
import org.esa.beam.glayer.GraticuleLayer;
import org.esa.beam.glayer.GraticuleLayerType;
import org.esa.beam.glayer.MaskCollectionLayerType;
import org.esa.beam.glayer.MaskLayerType;
import org.esa.beam.glayer.NoDataLayerType;
import org.esa.beam.glayer.ProductLayerContext;
import org.esa.beam.glayer.RasterImageLayerType;
import org.esa.beam.glayer.RgbImageLayerType;
import org.esa.beam.glevel.BandImageMultiLevelSource;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.util.PropertyMap;

public class ProductSceneImage
implements ProductLayerContext {
    private static final ImageLayerFilter IMAGE_LAYER_FILTER = new ImageLayerFilter();
    private final String name;
    private final PropertyMap configuration;
    private RasterDataNode[] rasters;
    private Layer rootLayer;
    private BandImageMultiLevelSource bandImageMultiLevelSource;

    public ProductSceneImage(RasterDataNode raster, PropertyMap configuration, ProgressMonitor pm) {
        this(raster.getDisplayName(), new RasterDataNode[]{raster}, configuration);
        this.bandImageMultiLevelSource = BandImageMultiLevelSource.create((RasterDataNode)raster, (ProgressMonitor)pm);
        this.initRootLayer();
    }

    public ProductSceneImage(RasterDataNode raster, ProductSceneView view) {
        this(raster.getDisplayName(), new RasterDataNode[]{raster}, view.getSceneImage().getConfiguration());
        this.bandImageMultiLevelSource = view.getSceneImage().getBandImageMultiLevelSource();
        this.initRootLayer();
    }

    public ProductSceneImage(String name, RasterDataNode redRaster, RasterDataNode greenRaster, RasterDataNode blueRaster, PropertyMap configuration, ProgressMonitor pm) {
        this(name, new RasterDataNode[]{redRaster, greenRaster, blueRaster}, configuration);
        this.bandImageMultiLevelSource = BandImageMultiLevelSource.create((RasterDataNode[])this.rasters, (ProgressMonitor)pm);
        this.initRootLayer();
    }

    private ProductSceneImage(String name, RasterDataNode[] rasters, PropertyMap configuration) {
        this.name = name;
        this.rasters = rasters;
        this.configuration = configuration;
    }

    public PropertyMap getConfiguration() {
        return this.configuration;
    }

    public String getName() {
        return this.name;
    }

    public ImageInfo getImageInfo() {
        return this.bandImageMultiLevelSource.getImageInfo();
    }

    public void setImageInfo(ImageInfo imageInfo) {
        this.bandImageMultiLevelSource.setImageInfo(imageInfo);
    }

    public RasterDataNode[] getRasters() {
        return this.rasters;
    }

    public void setRasters(RasterDataNode[] rasters) {
        this.rasters = rasters;
    }

    public Object getCoordinateReferenceSystem() {
        GeoCoding geoCoding = this.rasters[0].getGeoCoding();
        if (geoCoding != null) {
            return ImageManager.getModelCrs((GeoCoding)geoCoding);
        }
        return null;
    }

    public Layer getRootLayer() {
        return this.rootLayer;
    }

    Layer getLayer(String id) {
        return LayerUtils.getChildLayerById((Layer)this.getRootLayer(), (String)id);
    }

    void addLayer(int index, Layer layer) {
        this.rootLayer.getChildren().add(index, layer);
    }

    int getFirstImageLayerIndex() {
        return LayerUtils.getChildLayerIndex((Layer)this.getRootLayer(), (LayerUtils.SearchMode)LayerUtils.SEARCH_DEEP, (int)0, (LayerFilter)IMAGE_LAYER_FILTER);
    }

    ImageLayer getBaseImageLayer() {
        return (ImageLayer)this.getLayer("org.esa.beam.layers.baseImage");
    }

    Layer getNoDataLayer(boolean create) {
        Layer layer = this.getLayer("org.esa.beam.layers.noData");
        if (layer == null && create) {
            layer = this.createNoDataLayer();
            this.addLayer(this.getFirstImageLayerIndex(), layer);
        }
        return layer;
    }

    Layer getVectorDataCollectionLayer(boolean create) {
        Layer layer = this.getLayer(ProductSceneView.VECTOR_DATA_LAYER_ID);
        if (layer == null && create) {
            layer = this.createVectorDataCollectionLayer();
            this.addLayer(this.getFirstImageLayerIndex(), layer);
        }
        return layer;
    }

    Layer getMaskCollectionLayer(boolean create) {
        Layer layer = this.getLayer(ProductSceneView.MASKS_LAYER_ID);
        if (layer == null && create) {
            layer = this.createMaskCollectionLayer();
            this.addLayer(this.getFirstImageLayerIndex(), layer);
        }
        return layer;
    }

    GraticuleLayer getGraticuleLayer(boolean create) {
        GraticuleLayer layer = (GraticuleLayer)this.getLayer("org.esa.beam.layers.graticule");
        if (layer == null && create) {
            layer = this.createGraticuleLayer(this.getImageToModelTransform());
            this.addLayer(0, (Layer)layer);
        }
        return layer;
    }

    Layer getGcpLayer(boolean create) {
        VectorDataNode vectorDataNode = this.getProduct().getGcpGroup().getVectorDataNode();
        Layer vectorDataCollectionLayer = this.getVectorDataCollectionLayer(create);
        if (vectorDataCollectionLayer != null) {
            return LayerUtils.getChildLayer((Layer)this.getRootLayer(), (LayerUtils.SearchMode)LayerUtils.SEARCH_DEEP, (LayerFilter)VectorDataLayerFilterFactory.createNodeFilter(vectorDataNode));
        }
        return null;
    }

    Layer getPinLayer(boolean create) {
        VectorDataNode vectorDataNode = this.getProduct().getPinGroup().getVectorDataNode();
        Layer vectorDataCollectionLayer = this.getVectorDataCollectionLayer(create);
        if (vectorDataCollectionLayer != null) {
            return LayerUtils.getChildLayer((Layer)this.getRootLayer(), (LayerUtils.SearchMode)LayerUtils.SEARCH_DEEP, (LayerFilter)VectorDataLayerFilterFactory.createNodeFilter(vectorDataNode));
        }
        return null;
    }

    private RasterDataNode getRaster() {
        return this.rasters[0];
    }

    private void initRootLayer() {
        this.rootLayer = new CollectionLayer();
        this.addLayer(0, this.createBaseImageLayer());
    }

    public void initVectorDataCollectionLayer() {
        if (this.mustEnableVectorDataCollectionLayer()) {
            this.getVectorDataCollectionLayer(true);
        }
    }

    public void initMaskCollectionLayer() {
        if (this.mustEnableMaskCollectionLayer()) {
            this.getMaskCollectionLayer(true);
        }
    }

    private boolean mustEnableVectorDataCollectionLayer() {
        return this.getRaster().getProduct().getVectorDataGroup().getNodeCount() > 0;
    }

    private boolean mustEnableMaskCollectionLayer() {
        return this.getRaster().getOverlayMaskGroup().getNodeCount() > 0;
    }

    private AffineTransform getImageToModelTransform() {
        return this.bandImageMultiLevelSource.getModel().getImageToModelTransform(0);
    }

    private Layer createBaseImageLayer() {
        Layer layer;
        if (this.getRasters().length == 1) {
            RasterImageLayerType type = (RasterImageLayerType)LayerTypeRegistry.getLayerType(RasterImageLayerType.class);
            layer = type.createLayer(this.getRaster(), (MultiLevelSource)this.bandImageMultiLevelSource);
        } else {
            RgbImageLayerType type = (RgbImageLayerType)LayerTypeRegistry.getLayerType(RgbImageLayerType.class);
            layer = type.createLayer(this.getRasters(), this.bandImageMultiLevelSource);
        }
        layer.setName(this.getName());
        layer.setVisible(true);
        layer.setId("org.esa.beam.layers.baseImage");
        ProductSceneImage.setBaseImageLayerStyle(this.configuration, layer);
        return layer;
    }

    static void setBaseImageLayerStyle(PropertyMap configuration, Layer layer) {
        boolean borderShown = configuration.getPropertyBool("image.border.shown", false);
        double borderWidth = configuration.getPropertyDouble("image.border.size", 1.0);
        Color borderColor = configuration.getPropertyColor("image.border.color", ImageLayer.DEFAULT_BORDER_COLOR);
        boolean pixelBorderShown = configuration.getPropertyBool("pixel.border.shown", ImageLayer.DEFAULT_PIXEL_BORDER_SHOWN);
        double pixelBorderWidth = configuration.getPropertyDouble("pixel.border.size", 0.0);
        Color pixelBorderColor = configuration.getPropertyColor("pixel.border.color", ImageLayer.DEFAULT_PIXEL_BORDER_COLOR);
        PropertySet layerConfiguration = layer.getConfiguration();
        layerConfiguration.setValue("borderShown", (Object)borderShown);
        layerConfiguration.setValue("borderWidth", (Object)borderWidth);
        layerConfiguration.setValue("borderColor", (Object)borderColor);
        layerConfiguration.setValue("pixelBorderShown", (Object)pixelBorderShown);
        layerConfiguration.setValue("pixelBorderWidth", (Object)pixelBorderWidth);
        layerConfiguration.setValue("pixelBorderColor", (Object)pixelBorderColor);
    }

    private Layer createNoDataLayer() {
        LayerType noDataType = LayerTypeRegistry.getLayerType(NoDataLayerType.class);
        PropertySet configTemplate = noDataType.createLayerConfig(null);
        Color color = this.configuration.getPropertyColor("noDataOverlay.color", Color.ORANGE);
        configTemplate.setValue("color", (Object)color);
        configTemplate.setValue("raster", (Object)this.getRaster());
        Layer layer = noDataType.createLayer((LayerContext)this, configTemplate);
        double transparency = this.configuration.getPropertyDouble("noDataOverlay.transparency", 0.3);
        layer.setTransparency(transparency);
        return layer;
    }

    private synchronized Layer createVectorDataCollectionLayer() {
        VectorDataNode[] vectorDataNodes;
        LayerType collectionLayerType = LayerTypeRegistry.getLayerType(VectorDataCollectionLayerType.class);
        Layer collectionLayer = collectionLayerType.createLayer((LayerContext)this, collectionLayerType.createLayerConfig((LayerContext)this));
        ProductNodeGroup vectorDataGroup = this.getRaster().getProduct().getVectorDataGroup();
        for (VectorDataNode vectorDataNode : vectorDataNodes = (VectorDataNode[])vectorDataGroup.toArray((ProductNode[])new VectorDataNode[vectorDataGroup.getNodeCount()])) {
            VectorDataLayer layer = VectorDataLayerType.createLayer((LayerContext)this, vectorDataNode);
            collectionLayer.getChildren().add(layer);
        }
        return collectionLayer;
    }

    private synchronized Layer createMaskCollectionLayer() {
        LayerType maskCollectionType = LayerTypeRegistry.getLayerType(MaskCollectionLayerType.class);
        PropertySet layerConfig = maskCollectionType.createLayerConfig(null);
        layerConfig.setValue("raster", (Object)this.getRaster());
        Layer maskCollectionLayer = maskCollectionType.createLayer((LayerContext)this, layerConfig);
        ProductNodeGroup productNodeGroup = this.getRaster().getProduct().getMaskGroup();
        for (int i = 0; i < productNodeGroup.getNodeCount(); ++i) {
            Layer layer = MaskLayerType.createLayer((RasterDataNode)this.getRaster(), (Mask)((Mask)productNodeGroup.get(i)));
            maskCollectionLayer.getChildren().add(layer);
        }
        return maskCollectionLayer;
    }

    static void setNoDataLayerStyle(PropertyMap configuration, Layer layer) {
        PropertySet layerConfiguration = layer.getConfiguration();
        Color color = configuration.getPropertyColor("noDataOverlay.color", NoDataLayerType.DEFAULT_COLOR);
        layerConfiguration.setValue("color", (Object)color);
        double transparency = configuration.getPropertyDouble("noDataOverlay.transparency", 0.3);
        layer.setTransparency(transparency);
    }

    static void setFigureLayerStyle(PropertyMap configuration, Layer layer) {
        PropertySet layerConfiguration = layer.getConfiguration();
    }

    private GraticuleLayer createGraticuleLayer(AffineTransform i2mTransform) {
        LayerType layerType = LayerTypeRegistry.getLayerType(GraticuleLayerType.class);
        PropertySet template = layerType.createLayerConfig(null);
        template.setValue("raster", (Object)this.getRaster());
        GraticuleLayer graticuleLayer = (GraticuleLayer)layerType.createLayer(null, template);
        graticuleLayer.setId("org.esa.beam.layers.graticule");
        graticuleLayer.setVisible(false);
        graticuleLayer.setName("Graticule");
        ProductSceneImage.setGraticuleLayerStyle(this.configuration, (Layer)graticuleLayer);
        return graticuleLayer;
    }

    static void setGraticuleLayerStyle(PropertyMap configuration, Layer layer) {
        PropertySet layerConfiguration = layer.getConfiguration();
        layerConfiguration.setValue("graticule.res.auto", (Object)configuration.getPropertyBool("graticule.res.auto", true));
        layerConfiguration.setValue("graticule.res.pixels", (Object)configuration.getPropertyInt("graticule.res.pixels", 128));
        layerConfiguration.setValue("graticule.res.lat", (Object)configuration.getPropertyDouble("graticule.res.lat", 1.0));
        layerConfiguration.setValue("graticule.res.lon", (Object)configuration.getPropertyDouble("graticule.res.lon", 1.0));
        layerConfiguration.setValue("graticule.line.color", (Object)configuration.getPropertyColor("graticule.line.color", GraticuleLayerType.DEFAULT_LINE_COLOR));
        layerConfiguration.setValue("graticule.line.width", (Object)configuration.getPropertyDouble("graticule.line.width", 0.5));
        layerConfiguration.setValue("graticule.line.transparency", (Object)configuration.getPropertyDouble("graticule.line.transparency", 0.0));
        layerConfiguration.setValue("graticule.text.enabled", (Object)configuration.getPropertyBool("graticule.text.enabled", true));
        layerConfiguration.setValue("graticule.text.fg.color", (Object)configuration.getPropertyColor("graticule.text.fg.color", GraticuleLayerType.DEFAULT_TEXT_FG_COLOR));
        layerConfiguration.setValue("graticule.text.bg.color", (Object)configuration.getPropertyColor("graticule.text.bg.color", GraticuleLayerType.DEFAULT_TEXT_BG_COLOR));
        layerConfiguration.setValue("graticule.text.bg.transparency", (Object)configuration.getPropertyDouble("graticule.text.bg.transparency", 0.7));
    }

    private BandImageMultiLevelSource getBandImageMultiLevelSource() {
        return this.bandImageMultiLevelSource;
    }

    public Product getProduct() {
        return this.getRaster().getProduct();
    }

    private static class ImageLayerFilter
    implements LayerFilter {
        private ImageLayerFilter() {
        }

        public boolean accept(Layer layer) {
            return layer instanceof ImageLayer;
        }
    }
}

