/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product;

import com.bc.ceres.swing.TreeCellExtender;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.esa.beam.dataio.dimap.DimapProductReader;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductManager;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductNodeGroup;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.SampleCoding;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.datamodel.VectorDataNode;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.framework.ui.PopupMenuFactory;
import org.esa.beam.framework.ui.PopupMenuHandler;
import org.esa.beam.framework.ui.UIUtils;
import org.esa.beam.framework.ui.command.CommandManager;
import org.esa.beam.framework.ui.command.CommandUIFactory;
import org.esa.beam.framework.ui.product.ProductTreeListener;
import org.esa.beam.framework.ui.product.ProductTreeListener2;
import org.esa.beam.framework.ui.product.tree.AbstractTN;
import org.esa.beam.framework.ui.product.tree.ProductTreeModel;

public class ProductTree
extends JTree
implements PopupMenuFactory {
    private final Set<ProductNode> activeProductNodes;
    private final Map<ProductNode, Integer> openedProductNodes;
    private final ProductManagerListener productManagerListener;
    private final ProductTreeModelListener productTreeModelListener;
    private CommandManager commandManager;
    private CommandUIFactory commandUIFactory;
    private List<ProductTreeListener> productTreeListenerList;

    public ProductTree() {
        this(false);
    }

    public ProductTree(boolean multipleSelect) {
        super((TreeModel)null);
        this.getSelectionModel().setSelectionMode(multipleSelect ? 4 : 1);
        this.addTreeSelectionListener(new PTSelectionListener());
        this.addMouseListener(new PTMouseListener());
        this.setCellRenderer(new PTCellRenderer());
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setDragEnabled(true);
        this.setTransferHandler(new TreeTransferHandler());
        this.setToggleClickCount(2);
        this.setAutoscrolls(true);
        this.putClientProperty("JTree.lineStyle", "Angled");
        ToolTipManager.sharedInstance().registerComponent(this);
        PopupMenuHandler popupMenuHandler = new PopupMenuHandler(this);
        this.addMouseListener(popupMenuHandler);
        this.addKeyListener(popupMenuHandler);
        this.activeProductNodes = new HashSet<ProductNode>();
        this.openedProductNodes = new HashMap<ProductNode, Integer>();
        this.productManagerListener = new ProductManagerListener();
        this.productTreeModelListener = new ProductTreeModelListener(this);
        TreeCellExtender.equip((JTree)this);
        this.setDropTarget(new DropTarget(this, 3, new ProductTreeDropTarget()));
    }

    @Override
    public ProductTreeModel getModel() {
        return (ProductTreeModel)super.getModel();
    }

    @Override
    public void setModel(TreeModel newModel) {
        if (newModel != null && !(newModel instanceof ProductTreeModel)) {
            throw new IllegalStateException("newModel must be instance of ProductTreeModel");
        }
        if (this.getModel() != null) {
            ProductManager productManager = this.getModel().getProductManager();
            productManager.removeListener((ProductManager.Listener)this.productManagerListener);
            this.getModel().removeTreeModelListener(this.productTreeModelListener);
        }
        if (newModel != null) {
            ProductTreeModel ptm = (ProductTreeModel)newModel;
            ptm.getProductManager().addListener((ProductManager.Listener)this.productManagerListener);
            ptm.addTreeModelListener(this.productTreeModelListener);
        }
        super.setModel(newModel);
    }

    public void select(Object toSelect) {
        TreePath path = this.getModel().getTreePath(toSelect);
        if (path != null) {
            this.setSelectionPath(path);
        }
    }

    public void expand(Object toExpand) {
        TreePath path = this.getModel().getTreePath(toExpand);
        if (path != null) {
            this.makeVisible(path);
        }
    }

    public void registerOpenedProductNodes(ProductNode ... nodes) {
        for (ProductNode node : nodes) {
            Integer count = 1;
            if (this.openedProductNodes.containsKey(node)) {
                count = count + this.openedProductNodes.get(node);
            }
            this.openedProductNodes.put(node, count);
        }
        this.updateUI();
    }

    public void deregisterOpenedProductNodes(ProductNode ... nodes) {
        boolean changed = false;
        for (ProductNode node : nodes) {
            int count = -1;
            if (this.openedProductNodes.containsKey(node)) {
                count += this.openedProductNodes.get(node).intValue();
            }
            if (count == 0) {
                this.openedProductNodes.remove(node);
                changed = true;
                continue;
            }
            if (count <= 0) continue;
            this.openedProductNodes.put(node, count);
            changed = true;
        }
        if (changed) {
            this.updateUI();
        }
    }

    public void registerActiveProductNodes(ProductNode ... nodes) {
        if (this.activeProductNodes.addAll(Arrays.asList(nodes))) {
            this.updateUI();
        }
    }

    public void deregisterActiveProductNodes(ProductNode ... nodes) {
        if (this.activeProductNodes.removeAll(Arrays.asList(nodes))) {
            this.updateUI();
        }
    }

    @Override
    public JPopupMenu createPopupMenu(Component component) {
        return null;
    }

    @Override
    public JPopupMenu createPopupMenu(MouseEvent event) {
        TreePath selPath = this.getPathForLocation(event.getX(), event.getY());
        if (selPath != null) {
            Object context;
            this.setSelectionPath(selPath);
            AbstractTN node = (AbstractTN)this.getLastSelectedPathComponent();
            if (node != null && (context = node.getContent()) != null) {
                return this.createPopup(context);
            }
        }
        return null;
    }

    public void addProductTreeListener(ProductTreeListener listener) {
        if (listener != null) {
            if (this.productTreeListenerList == null) {
                this.productTreeListenerList = new ArrayList<ProductTreeListener>();
            }
            this.productTreeListenerList.add(listener);
        }
    }

    public void removeProductTreeListener(ProductTreeListener listener) {
        if (listener != null && this.productTreeListenerList != null) {
            this.productTreeListenerList.remove(listener);
        }
    }

    public void setCommandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public void setCommandUIFactory(CommandUIFactory commandUIFactory) {
        this.commandUIFactory = commandUIFactory;
    }

    public JPopupMenu createPopup(Object context) {
        JPopupMenu popup = new JPopupMenu();
        if (context instanceof Product) {
            if (this.commandUIFactory != null) {
                this.commandUIFactory.addContextDependentMenuItems("product", popup);
            }
        } else if (context instanceof MetadataElement) {
            int componentCountBefore = popup.getComponentCount();
            if (this.commandUIFactory != null) {
                this.commandUIFactory.addContextDependentMenuItems("metadataNode", popup);
            }
            ProductTree.addSeparatorIfAnyComponentsAdded(popup, componentCountBefore);
        } else if (context instanceof RasterDataNode) {
            if (context instanceof VirtualBand) {
                int componentCountBefore = popup.getComponentCount();
                if (this.commandUIFactory != null) {
                    this.commandUIFactory.addContextDependentMenuItems("virtualBand", popup);
                }
                ProductTree.addSeparatorIfAnyComponentsAdded(popup, componentCountBefore);
            }
            if (context instanceof TiePointGrid) {
                if (this.commandUIFactory != null) {
                    this.commandUIFactory.addContextDependentMenuItems("tiePointGrid", popup);
                }
            } else if (context instanceof Band && this.commandUIFactory != null) {
                this.commandUIFactory.addContextDependentMenuItems("band", popup);
            }
        } else if (context instanceof VectorDataNode && this.commandUIFactory != null) {
            this.commandUIFactory.addContextDependentMenuItems("vectorDataNode", popup);
        }
        return popup;
    }

    private static void addSeparatorIfAnyComponentsAdded(JPopupMenu popup, int componentCountBevore) {
        if (popup.getComponentCount() > componentCountBevore) {
            popup.addSeparator();
        }
    }

    private void fireProductAdded(Product product) {
        if (this.productTreeListenerList != null) {
            for (ProductTreeListener l : this.productTreeListenerList) {
                l.productAdded(product);
            }
        }
    }

    private void fireProductRemoved(Product product) {
        if (this.productTreeListenerList != null) {
            for (ProductTreeListener l : this.productTreeListenerList) {
                l.productRemoved(product);
            }
        }
    }

    private void fireNodeSelected(Object node, int clickCount) {
        if (this.productTreeListenerList != null) {
            for (ProductTreeListener l : this.productTreeListenerList) {
                if (node instanceof Product) {
                    l.productSelected((Product)node, clickCount);
                } else if (node instanceof ProductNodeGroup) {
                    l.productSelected(((ProductNode)node).getProduct(), clickCount);
                } else if (node instanceof MetadataElement) {
                    l.metadataElementSelected((MetadataElement)node, clickCount);
                } else if (node instanceof TiePointGrid) {
                    l.tiePointGridSelected((TiePointGrid)node, clickCount);
                } else if (node instanceof Band) {
                    l.bandSelected((Band)node, clickCount);
                } else if (node instanceof VectorDataNode) {
                    VectorDataNode vectorDataNode = (VectorDataNode)node;
                    if (l instanceof ProductTreeListener2) {
                        ProductTreeListener2 l2 = (ProductTreeListener2)l;
                        l2.vectorDataSelected(vectorDataNode, clickCount);
                    }
                }
                if (!(node instanceof ProductNode) || !(l instanceof ProductTreeListener2)) continue;
                ProductTreeListener2 l2 = (ProductTreeListener2)l;
                l2.productNodeSelected((ProductNode)node, clickCount);
            }
        }
    }

    public static class TreeTransferHandler
    extends TransferHandler {
        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return false;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            Product product;
            JTree tree = (JTree)c;
            TreePath path = tree.getSelectionPath();
            AbstractTN node = (AbstractTN)path.getLastPathComponent();
            Object context = node.getContent();
            if (context != null && context instanceof Product && (product = (Product)context).getFileLocation() != null) {
                return new StringSelection(product.getFileLocation().getAbsolutePath());
            }
            return null;
        }
    }

    private class ProductTreeDropTarget
    extends DropTargetAdapter {
        private DataFlavor uriListFlavor;

        private ProductTreeDropTarget() {
            try {
                this.uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            int dropAction = dtde.getDropAction();
            if ((dropAction & 3) != 0 && (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || this.uriListFlavor != null && dtde.isDataFlavorSupported(this.uriListFlavor))) {
                dtde.acceptDrag(3);
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            dtde.acceptDrop(3);
            boolean success = false;
            try {
                List<Object> fileList;
                Transferable transferable = dtde.getTransferable();
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    fileList = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                } else if (transferable.isDataFlavorSupported(this.uriListFlavor)) {
                    String data = (String)transferable.getTransferData(this.uriListFlavor);
                    fileList = this.textURIListToFileList(data);
                } else {
                    fileList = Collections.emptyList();
                }
                for (File file : fileList) {
                    Product product;
                    ProductManager productManager;
                    if (this.isProductAlreadyOpen(file, productManager = ProductTree.this.getModel().getProductManager()) || (product = ProductIO.readProduct((File)file)) == null) continue;
                    productManager.addProduct(product);
                    success = true;
                }
            }
            catch (UnsupportedFlavorException | IOException exception) {
                // empty catch block
            }
            dtde.dropComplete(success);
        }

        private boolean isProductAlreadyOpen(File file, ProductManager productManager) {
            for (int i = 0; i < productManager.getProductCount(); ++i) {
                Product product = productManager.getProduct(i);
                File productFile = product.getFileLocation();
                if (!file.equals(productFile)) continue;
                return true;
            }
            return false;
        }

        private List<File> textURIListToFileList(String data) {
            ArrayList<File> list = new ArrayList<File>(1);
            StringTokenizer st = new StringTokenizer(data, "\r\n");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.startsWith("#")) continue;
                try {
                    list.add(new File(new URI(token)));
                }
                catch (IllegalArgumentException | URISyntaxException ignore) {}
            }
            return list;
        }
    }

    private static class ProductTreeModelListener
    implements TreeModelListener {
        private ProductTree tree;

        private ProductTreeModelListener(ProductTree tree) {
            this.tree = tree;
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            this.tree.makeVisible(e.getTreePath());
            this.updateUi();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            this.updateUi();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            int selectionRow;
            this.updateUi();
            for (selectionRow = this.tree.getLeadSelectionRow(); selectionRow >= this.tree.getRowCount(); --selectionRow) {
            }
            if (selectionRow >= 0) {
                this.tree.setSelectionInterval(selectionRow, selectionRow);
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            this.updateUi();
        }

        private void updateUi() {
            this.tree.invalidate();
            this.tree.doLayout();
            this.tree.updateUI();
        }
    }

    private class ProductManagerListener
    implements ProductManager.Listener {
        private ProductManagerListener() {
        }

        public void productAdded(ProductManager.Event event) {
            ProductTree.this.fireProductAdded(event.getProduct());
            TreePath treePath = ProductTree.this.getModel().getTreePath(event.getProduct());
            ProductTree.this.expandPath(treePath);
            Rectangle bounds = ProductTree.this.getPathBounds(treePath);
            if (bounds != null) {
                bounds.setRect(0.0, bounds.y, bounds.width, bounds.height);
                ProductTree.this.scrollRectToVisible(bounds);
            }
        }

        public void productRemoved(ProductManager.Event event) {
            ProductTree.this.fireProductRemoved(event.getProduct());
        }
    }

    private class PTCellRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon productIcon = UIUtils.loadImageIcon("icons/RsProduct16.gif");
        private ImageIcon productIconModified = UIUtils.loadImageIcon("icons/RsProduct16-red.gif");
        private ImageIcon productIconOrigFormat = UIUtils.loadImageIcon("icons/RsProduct16-yellow.gif");
        private ImageIcon metadataIcon = UIUtils.loadImageIcon("icons/RsMetaData16.gif");
        private ImageIcon tiePointGridVisibleIcon;
        private ImageIcon tiePointGridInvisibleIcon;
        private ImageIcon bandVisibleIcon = UIUtils.loadImageIcon("icons/RsBandAsSwath16.gif");
        private ImageIcon bandInvisibleIcon = UIUtils.loadImageIcon("icons/RsBandAsSwath16Disabled.gif");
        private ImageIcon bandVirtualVisibleIcon;
        private ImageIcon bandVirtualInvisibleIcon;
        private ImageIcon bandFlagsVisibleIcon;
        private ImageIcon bandFlagsInvisibleIcon;
        private ImageIcon bandIndexedVisibleIcon;
        private ImageIcon bandIndexedInvisibleIcon;
        private ImageIcon vectorDataIcon;
        private Font normalFont;
        private Font boldFont;

        private PTCellRenderer() {
            this.tiePointGridVisibleIcon = UIUtils.loadImageIcon("icons/RsBandAsTiePoint16.gif");
            this.tiePointGridInvisibleIcon = UIUtils.loadImageIcon("icons/RsBandAsTiePoint16Disabled.gif");
            this.bandIndexedVisibleIcon = UIUtils.loadImageIcon("icons/RsBandIndexes16.gif");
            this.bandIndexedInvisibleIcon = UIUtils.loadImageIcon("icons/RsBandIndexes16Disabled.gif");
            this.bandFlagsVisibleIcon = UIUtils.loadImageIcon("icons/RsBandFlags16.gif");
            this.bandFlagsInvisibleIcon = UIUtils.loadImageIcon("icons/RsBandFlags16Disabled.gif");
            this.bandVirtualVisibleIcon = UIUtils.loadImageIcon("icons/RsBandVirtual16.gif");
            this.bandVirtualInvisibleIcon = UIUtils.loadImageIcon("icons/RsBandVirtual16Disabled.gif");
            this.vectorDataIcon = UIUtils.loadImageIcon("icons/RsVectorData16.gif");
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (this.normalFont == null) {
                this.normalFont = this.getFont();
                this.boldFont = this.getFont().deriveFont(1);
            }
            AbstractTN treeNode = (AbstractTN)value;
            value = treeNode.getContent();
            this.setFont(this.normalFont);
            if (value instanceof ProductNode) {
                String str;
                ProductNode productNode = (ProductNode)value;
                boolean active = ProductTree.this.activeProductNodes.contains(productNode);
                boolean opened = ProductTree.this.openedProductNodes.containsKey(productNode);
                if (active) {
                    this.setFont(this.boldFont);
                }
                String text = productNode.getName();
                StringBuilder toolTipBuffer = new StringBuilder(32);
                String prefix = productNode.getProductRefString();
                if (prefix != null) {
                    toolTipBuffer.append(prefix);
                    toolTipBuffer.append(' ');
                }
                if ((str = productNode.getDescription()) != null && str.length() != 0) {
                    toolTipBuffer.append(productNode.getDescription());
                } else {
                    toolTipBuffer.append(productNode.getName());
                }
                if (productNode instanceof Product) {
                    text = productNode.getDisplayName();
                    Product product = (Product)productNode;
                    if (product.isModified()) {
                        this.setIcon(this.productIconModified);
                    } else if (product.getProductReader() instanceof DimapProductReader) {
                        this.setIcon(this.productIcon);
                    } else {
                        this.setIcon(this.productIconOrigFormat);
                    }
                    toolTipBuffer.append(", ");
                    toolTipBuffer.append(product.getSceneRasterWidth());
                    toolTipBuffer.append(" x ");
                    toolTipBuffer.append(product.getSceneRasterHeight());
                    toolTipBuffer.append(" pixels");
                } else if (productNode instanceof ProductNodeGroup) {
                    text = treeNode.getName();
                } else if (productNode instanceof MetadataElement) {
                    MetadataElement metadataElement = (MetadataElement)productNode;
                    if (metadataElement.getParentElement() != null || metadataElement instanceof SampleCoding) {
                        this.setIcon(this.metadataIcon);
                    } else {
                        text = treeNode.getName();
                    }
                } else if (productNode instanceof Band) {
                    Band band = (Band)productNode;
                    if ((double)band.getSpectralWavelength() > 0.0) {
                        text = band.getSpectralWavelength() == (float)Math.round(band.getSpectralWavelength()) ? String.format("%s (%d nm)", productNode.getName(), (int)band.getSpectralWavelength()) : String.format("%s (%s nm)", productNode.getName(), String.valueOf(band.getSpectralWavelength()));
                        toolTipBuffer.append(", wavelength = ");
                        toolTipBuffer.append(band.getSpectralWavelength());
                        toolTipBuffer.append(" nm, bandwidth = ");
                        toolTipBuffer.append(band.getSpectralBandwidth());
                        toolTipBuffer.append(" nm");
                    }
                    if (band instanceof VirtualBand) {
                        toolTipBuffer.append(", expr = ");
                        toolTipBuffer.append(((VirtualBand)band).getExpression());
                        if (opened) {
                            this.setIcon(this.bandVirtualVisibleIcon);
                        } else {
                            this.setIcon(this.bandVirtualInvisibleIcon);
                        }
                    } else if (band.getFlagCoding() != null) {
                        if (opened) {
                            this.setIcon(this.bandFlagsVisibleIcon);
                        } else {
                            this.setIcon(this.bandFlagsInvisibleIcon);
                        }
                    } else if (band.getIndexCoding() != null) {
                        if (opened) {
                            this.setIcon(this.bandIndexedVisibleIcon);
                        } else {
                            this.setIcon(this.bandIndexedInvisibleIcon);
                        }
                    } else if (opened) {
                        this.setIcon(this.bandVisibleIcon);
                    } else {
                        this.setIcon(this.bandInvisibleIcon);
                    }
                    toolTipBuffer.append(", raster size = ");
                    toolTipBuffer.append(band.getRasterWidth());
                    toolTipBuffer.append(" x ");
                    toolTipBuffer.append(band.getRasterHeight());
                } else if (productNode instanceof TiePointGrid) {
                    TiePointGrid tiePointGrid = (TiePointGrid)productNode;
                    if (opened) {
                        this.setIcon(this.tiePointGridVisibleIcon);
                    } else {
                        this.setIcon(this.tiePointGridInvisibleIcon);
                    }
                    toolTipBuffer.append(", raster size = ");
                    toolTipBuffer.append(tiePointGrid.getRasterWidth());
                    toolTipBuffer.append(" x ");
                    toolTipBuffer.append(tiePointGrid.getRasterHeight());
                } else if (productNode instanceof VectorDataNode) {
                    VectorDataNode vectorDataNode = (VectorDataNode)productNode;
                    this.setIcon(this.vectorDataIcon);
                    toolTipBuffer.append(", type = ");
                    toolTipBuffer.append(vectorDataNode.getFeatureType().getTypeName());
                    toolTipBuffer.append(", #features = ");
                    toolTipBuffer.append(vectorDataNode.getFeatureCollection().size());
                }
                this.setText(text);
                this.setToolTipText(toolTipBuffer.toString());
            }
            return this;
        }
    }

    private class PTSelectionListener
    implements TreeSelectionListener {
        private PTSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent event) {
            AbstractTN node = (AbstractTN)ProductTree.this.getLastSelectedPathComponent();
            if (node != null) {
                ProductTree.this.fireNodeSelected(node.getContent(), 1);
            }
        }
    }

    private class PTMouseListener
    extends MouseAdapter {
        private PTMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            int selRow = ProductTree.this.getRowForLocation(event.getX(), event.getY());
            if (selRow >= 0) {
                int clickCount = event.getClickCount();
                TreePath selPath = ProductTree.this.getPathForLocation(event.getX(), event.getY());
                if (selPath != null) {
                    AbstractTN node = (AbstractTN)selPath.getLastPathComponent();
                    ProductTree.this.fireNodeSelected(node.getContent(), clickCount);
                }
            }
        }
    }
}

