/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product;

import com.bc.ceres.swing.figure.FigureFactory;
import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.PointFigure;
import com.bc.ceres.swing.figure.ShapeFigure;
import com.bc.ceres.swing.figure.support.DefaultFigureStyle;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Point2D;
import org.esa.beam.framework.datamodel.PlainFeatureFactory;
import org.esa.beam.framework.ui.product.SimpleFeatureFigure;
import org.esa.beam.framework.ui.product.SimpleFeaturePointFigure;
import org.esa.beam.framework.ui.product.SimpleFeatureShapeFigure;
import org.esa.beam.util.AwtGeomToJtsGeomConverter;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class SimpleFeatureFigureFactory
implements FigureFactory {
    private final SimpleFeatureType simpleFeatureType;
    private final AwtGeomToJtsGeomConverter toJtsGeom;
    private long currentFeatureId;

    public SimpleFeatureFigureFactory(SimpleFeatureType simpleFeatureType) {
        this.simpleFeatureType = simpleFeatureType;
        this.toJtsGeom = new AwtGeomToJtsGeomConverter();
        this.currentFeatureId = System.nanoTime();
    }

    public PointFigure createPointFigure(Point2D point, FigureStyle style) {
        Point point1 = this.toJtsGeom.createPoint(point);
        return this.createPointFigure(point1, style);
    }

    public ShapeFigure createLineFigure(Shape shape, FigureStyle style) {
        MultiLineString multiLineString = this.toJtsGeom.createMultiLineString(shape);
        if (multiLineString.getNumGeometries() == 1) {
            return this.createShapeFigure(multiLineString.getGeometryN(0), style);
        }
        return this.createShapeFigure((Geometry)multiLineString, style);
    }

    public ShapeFigure createPolygonFigure(Shape shape, FigureStyle style) {
        Polygon polygon = this.toJtsGeom.createPolygon(shape);
        return this.createShapeFigure((Geometry)polygon, style);
    }

    public PointFigure createPointFigure(Point geometry, FigureStyle style) {
        return new SimpleFeaturePointFigure(this.createSimpleFeature((Geometry)geometry), style);
    }

    public SimpleFeatureFigure createSimpleFeatureFigure(SimpleFeature simpleFeature, String defaultStyleCss) {
        String css = SimpleFeatureFigureFactory.getStyleCss(simpleFeature, defaultStyleCss);
        FigureStyle normalStyle = DefaultFigureStyle.createFromCss((String)css);
        FigureStyle selectedStyle = this.deriveSelectedStyle(normalStyle);
        Object geometry = simpleFeature.getDefaultGeometry();
        if (geometry instanceof Point) {
            return new SimpleFeaturePointFigure(simpleFeature, normalStyle, selectedStyle);
        }
        return new SimpleFeatureShapeFigure(simpleFeature, normalStyle, selectedStyle);
    }

    static String getStyleCss(SimpleFeature simpleFeature, String defaultStyleCss) {
        String css;
        Object styleAttribute = simpleFeature.getAttribute("style_css");
        if (styleAttribute instanceof String && !(css = (String)styleAttribute).trim().isEmpty()) {
            String[] cssAttributes;
            StringBuilder sb = new StringBuilder(css);
            for (String cssAttribute : cssAttributes = defaultStyleCss.split(";")) {
                if (css.contains(cssAttribute.split(":")[0].trim())) continue;
                sb.append(";");
                sb.append(cssAttribute);
            }
            return sb.toString();
        }
        return defaultStyleCss;
    }

    public ShapeFigure createShapeFigure(Geometry geometry, FigureStyle style) {
        return new SimpleFeatureShapeFigure(this.createSimpleFeature(geometry), style, this.deriveSelectedStyle(style));
    }

    public SimpleFeature createSimpleFeature(Geometry geometry) {
        return PlainFeatureFactory.createPlainFeature((SimpleFeatureType)this.simpleFeatureType, (String)("ID" + Long.toHexString(this.currentFeatureId++)), (Geometry)geometry, null);
    }

    public FigureStyle deriveSelectedStyle(FigureStyle style) {
        DefaultFigureStyle figureStyle = new DefaultFigureStyle();
        figureStyle.setFillColor(style.getFillColor());
        figureStyle.setFillOpacity(style.getFillOpacity());
        figureStyle.setStrokeColor(Color.YELLOW);
        figureStyle.setStrokeOpacity(0.75);
        figureStyle.setStrokeWidth(style.getStrokeWidth() + 1.0);
        figureStyle.setSymbolName(style.getSymbolName());
        figureStyle.setSymbolImagePath(style.getSymbolImagePath());
        figureStyle.setSymbolRefX(style.getSymbolRefX());
        figureStyle.setSymbolRefY(style.getSymbolRefY());
        return figureStyle;
    }
}

