/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product;

import com.bc.ceres.swing.figure.AbstractShapeFigure;
import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureStyle;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Lineal;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.Puntal;
import java.awt.Shape;
import org.esa.beam.framework.ui.product.SimpleFeatureFigure;
import org.esa.beam.util.AwtGeomToJtsGeomConverter;
import org.esa.beam.util.Debug;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.LiteShape2;
import org.opengis.feature.simple.SimpleFeature;

public class SimpleFeatureShapeFigure
extends AbstractShapeFigure
implements SimpleFeatureFigure {
    private SimpleFeature simpleFeature;
    private Shape geometryShape;
    private final Class<?> geometryType;

    public SimpleFeatureShapeFigure(SimpleFeature simpleFeature, FigureStyle style) {
        this(simpleFeature, style, style);
    }

    public SimpleFeatureShapeFigure(SimpleFeature simpleFeature, FigureStyle normalStyle, FigureStyle selectedStyle) {
        super(SimpleFeatureShapeFigure.getRank(simpleFeature), normalStyle, selectedStyle);
        this.simpleFeature = simpleFeature;
        this.geometryType = simpleFeature.getDefaultGeometry().getClass();
        this.geometryShape = null;
    }

    public Object createMemento() {
        return this.getGeometry().clone();
    }

    public void setMemento(Object memento) {
        this.simpleFeature.setDefaultGeometry(memento);
        this.forceRegeneration();
        this.fireFigureChanged();
    }

    @Override
    public SimpleFeature getSimpleFeature() {
        return this.simpleFeature;
    }

    @Override
    public Geometry getGeometry() {
        return (Geometry)this.simpleFeature.getDefaultGeometry();
    }

    @Override
    public void setGeometry(Geometry geometry) {
        if (!this.geometryType.isAssignableFrom(geometry.getClass())) {
            Debug.trace((String)("WARNING: Assigning a geometry of type " + geometry.getClass() + ", should actually be a " + this.geometryType));
        }
        this.simpleFeature.setDefaultGeometry((Object)geometry);
        this.forceRegeneration();
        this.fireFigureChanged();
    }

    public Shape getShape() {
        try {
            if (this.geometryShape == null) {
                this.geometryShape = new LiteShape2(this.getGeometry(), null, null, true);
            }
            return this.geometryShape;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("simpleFeature", e);
        }
    }

    @Override
    public void forceRegeneration() {
        this.geometryShape = null;
    }

    public void setShape(Shape shape) {
        AwtGeomToJtsGeomConverter converter = new AwtGeomToJtsGeomConverter();
        Object geometry = Polygon.class.isAssignableFrom(this.geometryType) ? converter.createPolygon(shape) : (MultiPolygon.class.isAssignableFrom(this.geometryType) ? converter.createMultiPolygon(shape) : converter.createMultiLineString(shape));
        this.setGeometry((Geometry)geometry);
    }

    public Object clone() {
        SimpleFeatureShapeFigure clone = (SimpleFeatureShapeFigure)super.clone();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(this.simpleFeature.getFeatureType());
        builder.init(this.simpleFeature);
        clone.simpleFeature = builder.buildFeature(null);
        clone.simpleFeature.setDefaultGeometry(this.getGeometry().clone());
        clone.geometryShape = null;
        return clone;
    }

    static Figure.Rank getRank(SimpleFeature simpleFeature) {
        Object geometry = simpleFeature.getDefaultGeometry();
        if (!(geometry instanceof Geometry)) {
            throw new IllegalArgumentException("simpleFeature: geometry type must be a " + Geometry.class);
        }
        return SimpleFeatureShapeFigure.getRank((Geometry)geometry);
    }

    static Figure.Rank getRank(Geometry geometry) {
        if (geometry instanceof Puntal) {
            return Figure.Rank.POINT;
        }
        if (geometry instanceof Lineal) {
            return Figure.Rank.LINE;
        }
        if (geometry instanceof Polygonal) {
            return Figure.Rank.AREA;
        }
        return Figure.Rank.NOT_SPECIFIED;
    }
}

