/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product;

import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureEditor;
import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.support.DefaultFigureEditor;
import com.bc.ceres.swing.figure.support.DefaultFigureStyle;
import com.bc.ceres.swing.figure.support.FigureDeleteEdit;
import com.bc.ceres.swing.figure.support.FigureInsertEdit;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.esa.beam.framework.datamodel.VectorDataNode;
import org.esa.beam.framework.ui.product.ProductSceneView;
import org.esa.beam.framework.ui.product.SimpleFeatureFigure;
import org.esa.beam.framework.ui.product.VectorDataLayer;
import org.esa.beam.util.Debug;
import org.opengis.feature.simple.SimpleFeature;

public class VectorDataFigureEditor
extends DefaultFigureEditor {
    private final ProductSceneView productSceneView;
    private VectorDataNode vectorDataNode;

    public VectorDataFigureEditor(ProductSceneView productSceneView) {
        super((JComponent)productSceneView.getLayerCanvas(), productSceneView.getLayerCanvas().getViewport(), productSceneView.getUndoContext(), ProductSceneView.NullFigureCollection.INSTANCE, null);
        this.productSceneView = productSceneView;
    }

    public ProductSceneView getProductSceneView() {
        return this.productSceneView;
    }

    public VectorDataNode getVectorDataNode() {
        return this.vectorDataNode;
    }

    public void vectorDataLayerSelected(VectorDataLayer vectorDataLayer) {
        Debug.trace((String)("VectorDataFigureEditor.vectorDataLayerSelected: " + vectorDataLayer.getName()));
        this.vectorDataNode = vectorDataLayer.getVectorDataNode();
        this.setFigureCollection(vectorDataLayer.getFigureCollection());
        this.setFigureFactory(vectorDataLayer.getFigureFactory());
        DefaultFigureStyle style = new DefaultFigureStyle();
        style.fromCssString(vectorDataLayer.getVectorDataNode().getDefaultStyleCss());
        this.setDefaultLineStyle((FigureStyle)style);
        this.setDefaultPolygonStyle((FigureStyle)style);
    }

    public void insertFigures(boolean performInsert, Figure ... figures) {
        Debug.trace((String)("VectorDataFigureEditor.insertFigures " + performInsert + ", " + figures.length));
        if (this.vectorDataNode != null) {
            final List<SimpleFeature> simpleFeatures = this.toSimpleFeatureList(figures);
            this.vectorDataNode.getFeatureCollection().addAll(simpleFeatures);
            this.getUndoContext().postEdit((UndoableEdit)new FigureInsertEdit((FigureEditor)this, performInsert, figures){

                public void undo() throws CannotUndoException {
                    super.undo();
                    VectorDataFigureEditor.this.vectorDataNode.getFeatureCollection().removeAll((Collection)simpleFeatures);
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    VectorDataFigureEditor.this.vectorDataNode.getFeatureCollection().addAll((Collection)simpleFeatures);
                }
            });
        } else {
            super.insertFigures(performInsert, figures);
        }
    }

    public void deleteFigures(boolean performDelete, Figure ... figures) {
        Debug.trace((String)("VectorDataFigureEditor.deleteFigures " + performDelete + ", " + figures.length));
        if (this.vectorDataNode != null) {
            final List<SimpleFeature> simpleFeatures = this.toSimpleFeatureList(figures);
            this.vectorDataNode.getFeatureCollection().removeAll(simpleFeatures);
            this.getUndoContext().postEdit((UndoableEdit)new FigureDeleteEdit((FigureEditor)this, performDelete, figures){

                public void undo() throws CannotUndoException {
                    super.undo();
                    VectorDataFigureEditor.this.vectorDataNode.getFeatureCollection().addAll((Collection)simpleFeatures);
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    VectorDataFigureEditor.this.vectorDataNode.getFeatureCollection().removeAll((Collection)simpleFeatures);
                }
            });
        } else {
            super.deleteFigures(performDelete, figures);
        }
    }

    public void changeFigure(Figure figure, Object figureMemento, String presentationName) {
        Debug.trace((String)("VectorDataFigureEditor.changeFigure " + figure + ", " + presentationName));
        super.changeFigure(figure, figureMemento, presentationName);
        if (this.vectorDataNode != null && figure instanceof SimpleFeatureFigure) {
            SimpleFeatureFigure featureFigure = (SimpleFeatureFigure)figure;
            this.vectorDataNode.fireFeaturesChanged(new SimpleFeature[]{featureFigure.getSimpleFeature()});
        }
    }

    private List<SimpleFeature> toSimpleFeatureList(Figure[] figures) {
        SimpleFeature[] features = new SimpleFeature[figures.length];
        for (Figure figure : figures) {
            if (!(figure instanceof SimpleFeatureFigure)) continue;
            SimpleFeatureFigure simpleFeatureFigure = (SimpleFeatureFigure)figure;
            features[i] = simpleFeatureFigure.getSimpleFeature();
        }
        return Arrays.asList(features);
    }
}

