/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product;

import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerFilter;
import org.esa.beam.framework.datamodel.VectorDataNode;
import org.esa.beam.framework.ui.product.VectorDataLayer;

public class VectorDataLayerFilterFactory {
    public static LayerFilter createGeometryFilter() {
        return new TypeNameFilter("org.esa.beam.Geometry");
    }

    public static LayerFilter createNodeFilter(VectorDataNode vectorDataNode) {
        return new NodeFilter(vectorDataNode);
    }

    private static class NodeFilter
    implements LayerFilter {
        private final VectorDataNode vectorDataNode;

        private NodeFilter(VectorDataNode vectorDataNode) {
            this.vectorDataNode = vectorDataNode;
        }

        public boolean accept(Layer layer) {
            return layer instanceof VectorDataLayer && ((VectorDataLayer)layer).getVectorDataNode() == this.vectorDataNode;
        }
    }

    private static class TypeNameFilter
    implements LayerFilter {
        private final String featureTypeName;

        private TypeNameFilter(String featureTypeName) {
            this.featureTypeName = featureTypeName;
        }

        public boolean accept(Layer layer) {
            return layer instanceof VectorDataLayer && this.featureTypeName.equals(((VectorDataLayer)layer).getVectorDataNode().getFeatureType().getTypeName());
        }
    }
}

