/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.core.Assert;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.glayer.LayerTypeRegistry;
import com.bc.ceres.glayer.annotations.LayerTypeMetadata;
import org.esa.beam.framework.datamodel.VectorDataNode;
import org.esa.beam.framework.ui.product.VectorDataLayer;
import org.esa.beam.glayer.ProductLayerContext;

@LayerTypeMetadata(name="VectorDataLayerType", aliasNames={"org.esa.beam.framework.ui.product.VectorDataLayerType"})
public class VectorDataLayerType
extends LayerType {
    public static final String PROPERTY_NAME_VECTOR_DATA = "vectorData";
    public static final String VECTOR_DATA_LAYER_ID_PREFIX = "org.esa.beam.layers.vectorData";

    public static VectorDataLayer createLayer(LayerContext ctx, VectorDataNode vectorDataNode) {
        VectorDataLayer layer;
        VectorDataLayerType specialLayerType = (VectorDataLayerType)((Object)vectorDataNode.getExtension(VectorDataLayerType.class));
        if (specialLayerType != null) {
            layer = specialLayerType.createLayerInternal(ctx, vectorDataNode);
        } else {
            VectorDataLayerType fallbackLayerType = (VectorDataLayerType)LayerTypeRegistry.getLayerType(VectorDataLayerType.class);
            if (fallbackLayerType == null) {
                throw new IllegalStateException("fallbackLayerType == null (missing default VectorDataLayerType)");
            }
            layer = fallbackLayerType.createLayerInternal(ctx, vectorDataNode);
        }
        return layer;
    }

    public boolean isValidFor(LayerContext ctx) {
        return ctx instanceof ProductLayerContext;
    }

    public Layer createLayer(LayerContext ctx, PropertySet configuration) {
        Assert.notNull((Object)ctx, (String)"ctx");
        ProductLayerContext plc = (ProductLayerContext)ctx;
        String vectorDataName = (String)configuration.getValue(PROPERTY_NAME_VECTOR_DATA);
        VectorDataNode vectorDataNode = (VectorDataNode)plc.getProduct().getVectorDataGroup().get(vectorDataName);
        Assert.notNull((Object)vectorDataNode, (String)String.format("VectorDataNode '%s' does not exist", vectorDataName));
        return this.createLayer(vectorDataNode, configuration);
    }

    public PropertySet createLayerConfig(LayerContext ctx) {
        return VectorDataLayerType.createLayerConfig();
    }

    public static PropertySet createLayerConfig() {
        PropertyContainer configuration = new PropertyContainer();
        configuration.addProperty(Property.create((String)PROPERTY_NAME_VECTOR_DATA, String.class));
        return configuration;
    }

    protected VectorDataLayer createLayer(VectorDataNode vectorDataNode, PropertySet configuration) {
        return new VectorDataLayer(this, vectorDataNode, configuration);
    }

    private VectorDataLayer createLayerInternal(LayerContext ctx, VectorDataNode vectorDataNode) {
        PropertySet configuration = this.createLayerConfig(ctx);
        configuration.setValue(PROPERTY_NAME_VECTOR_DATA, (Object)vectorDataNode.getName());
        return this.createLayer(vectorDataNode, configuration);
    }
}

