/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product.spectrum;

import com.bc.ceres.swing.TableLayout;
import com.jidesoft.grid.AutoFilterTableHeader;
import com.jidesoft.grid.HierarchicalTable;
import com.jidesoft.grid.HierarchicalTableComponentFactory;
import com.jidesoft.grid.HierarchicalTableModel;
import com.jidesoft.grid.JideTable;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TreeLikeHierarchicalPanel;
import com.jidesoft.grid.TristateCheckBoxCellEditor;
import com.jidesoft.swing.TristateCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.ui.DecimalTableCellRenderer;
import org.esa.beam.framework.ui.ModalDialog;
import org.esa.beam.framework.ui.product.LoadSaveRasterDataNodesConfigurationsComponent;
import org.esa.beam.framework.ui.product.LoadSaveRasterDataNodesConfigurationsProvider;
import org.esa.beam.framework.ui.product.spectrum.DisplayableSpectrum;
import org.esa.beam.framework.ui.product.spectrum.SpectrumSelectionAdmin;
import org.esa.beam.framework.ui.product.spectrum.SpectrumShapeProvider;
import org.esa.beam.framework.ui.product.spectrum.SpectrumStrokeProvider;
import org.esa.beam.util.ArrayUtils;

public class SpectrumChooser
extends ModalDialog
implements LoadSaveRasterDataNodesConfigurationsComponent {
    private static final int spectrumSelectedIndex = 0;
    private static final int spectrumNameIndex = 1;
    private static final int spectrumUnitIndex = 2;
    private static final int spectrumStrokeIndex = 3;
    private static final int spectrumShapeIndex = 4;
    private static final int spectrumShapeSizeIndex = 5;
    private static final int bandSelectedIndex = 0;
    private static final int bandNameIndex = 1;
    private static final int bandDescriptionIndex = 2;
    private static final int bandWavelengthIndex = 3;
    private static final int bandBandwidthIndex = 4;
    private static final int bandUnitIndex = 5;
    private static HierarchicalTable spectraTable;
    private final DisplayableSpectrum[] originalSpectra;
    private DisplayableSpectrum[] spectra;
    private static SpectrumSelectionAdmin selectionAdmin;
    private static boolean selectionChangeLock;
    private final Map<Integer, SortableTable> rowToBandsTable;

    public SpectrumChooser(Window parent, DisplayableSpectrum[] originalSpectra) {
        super(parent, "Available Spectra", 161, "spectrumChooser");
        if (originalSpectra != null) {
            this.originalSpectra = originalSpectra;
            ArrayList<DisplayableSpectrum> spectraWithBands = new ArrayList<DisplayableSpectrum>();
            for (DisplayableSpectrum spectrum : originalSpectra) {
                if (!spectrum.hasBands()) continue;
                spectraWithBands.add(spectrum);
            }
            this.spectra = spectraWithBands.toArray(new DisplayableSpectrum[spectraWithBands.size()]);
        } else {
            this.originalSpectra = new DisplayableSpectrum[0];
            this.spectra = new DisplayableSpectrum[0];
        }
        selectionAdmin = new SpectrumSelectionAdmin();
        selectionChangeLock = false;
        this.rowToBandsTable = new HashMap<Integer, SortableTable>();
        this.initUI();
    }

    private void initUI() {
        JPanel content = new JPanel(new BorderLayout());
        this.initSpectraTable();
        JScrollPane spectraScrollPane = new JScrollPane((Component)spectraTable);
        Dimension preferredSize = spectraTable.getPreferredSize();
        spectraScrollPane.setPreferredSize(new Dimension(Math.max(preferredSize.width + 20, 550), Math.max(preferredSize.height + 10, 200)));
        content.add((Component)spectraScrollPane, "Center");
        LoadSaveRasterDataNodesConfigurationsProvider provider = new LoadSaveRasterDataNodesConfigurationsProvider(this);
        AbstractButton loadButton = provider.getLoadButton();
        AbstractButton saveButton = provider.getSaveButton();
        TableLayout layout = new TableLayout(1);
        layout.setTablePadding(4, 4);
        JPanel buttonPanel = new JPanel((LayoutManager)layout);
        buttonPanel.add(loadButton);
        buttonPanel.add(saveButton);
        buttonPanel.add(layout.createVerticalSpacer());
        content.add((Component)buttonPanel, "East");
        this.setContent(content);
    }

    private void initSpectraTable() {
        SpectrumTableModel spectrumTableModel = new SpectrumTableModel();
        spectraTable = new HierarchicalTable((TableModel)spectrumTableModel);
        spectraTable.setComponentFactory((HierarchicalTableComponentFactory)new SpectrumTableComponentFactory());
        AutoFilterTableHeader header = new AutoFilterTableHeader((JTable)spectraTable);
        spectraTable.setTableHeader((JTableHeader)header);
        spectraTable.setRowHeight(21);
        SortableTableModel sortableTableModel = (SortableTableModel)TableModelWrapperUtils.getActualTableModel((TableModel)spectraTable.getModel(), SortableTableModel.class);
        sortableTableModel.setColumnSortable(3, false);
        sortableTableModel.setColumnSortable(4, false);
        TableColumn selectionColumn = spectraTable.getColumnModel().getColumn(0);
        TristateCheckBoxCellEditor tristateCheckBoxCellEditor = new TristateCheckBoxCellEditor();
        selectionColumn.setCellEditor((TableCellEditor)tristateCheckBoxCellEditor);
        selectionColumn.setCellRenderer(new TriStateRenderer());
        selectionColumn.setMinWidth(38);
        selectionColumn.setMaxWidth(38);
        TableColumn nameColumn = spectraTable.getColumnModel().getColumn(1);
        nameColumn.setCellRenderer(new TextFieldRenderer());
        TableColumn strokeColumn = spectraTable.getColumnModel().getColumn(3);
        JComboBox<ImageIcon> strokeComboBox = new JComboBox<ImageIcon>(SpectrumStrokeProvider.getStrokeIcons());
        ImageIconComboBoxRenderer strokeComboBoxRenderer = new ImageIconComboBoxRenderer(3);
        strokeComboBoxRenderer.setPreferredSize(new Dimension(200, 30));
        strokeComboBox.setRenderer(strokeComboBoxRenderer);
        strokeColumn.setCellEditor(new DefaultCellEditor(strokeComboBox));
        TableColumn shapeColumn = spectraTable.getColumnModel().getColumn(4);
        JComboBox<ImageIcon> shapeComboBox = new JComboBox<ImageIcon>(SpectrumShapeProvider.getShapeIcons());
        ImageIconComboBoxRenderer shapeComboBoxRenderer = new ImageIconComboBoxRenderer(4);
        shapeComboBoxRenderer.setPreferredSize(new Dimension(200, 30));
        shapeComboBox.setRenderer(shapeComboBoxRenderer);
        shapeColumn.setCellEditor(new DefaultCellEditor(shapeComboBox));
        TableColumn shapeSizeColumn = spectraTable.getColumnModel().getColumn(5);
        JComboBox<Integer> shapeSizeComboBox = new JComboBox<Integer>(SpectrumShapeProvider.getScaleGrades());
        shapeSizeColumn.setCellEditor(new DefaultCellEditor(shapeSizeComboBox));
    }

    private static SpectrumTableModel getSpectrumTableModel() {
        return (SpectrumTableModel)TableModelWrapperUtils.getActualTableModel((TableModel)spectraTable.getModel());
    }

    public DisplayableSpectrum[] getSpectra() {
        return this.originalSpectra;
    }

    @Override
    public void setReadRasterDataNodeNames(String[] readRasterDataNodeNames) {
        SpectrumTableModel spectrumTableModel = SpectrumChooser.getSpectrumTableModel();
        for (int i = 0; i < spectraTable.getRowCount(); ++i) {
            BandTableModel bandTableModel = spectrumTableModel.getBandTableModel(i);
            for (int j = 0; j < bandTableModel.getRowCount(); ++j) {
                String bandName = bandTableModel.getValueAt(j, 1).toString();
                boolean selected = ArrayUtils.isMemberOf((Object)bandName, (Object[])readRasterDataNodeNames);
                bandTableModel.setValueAt(selected, j, 0);
            }
        }
    }

    @Override
    public String[] getRasterDataNodeNamesToWrite() {
        ArrayList<String> bandNames = new ArrayList<String>();
        SpectrumTableModel spectrumTableModel = SpectrumChooser.getSpectrumTableModel();
        for (int i = 0; i < spectrumTableModel.getRowCount(); ++i) {
            BandTableModel bandTableModel = spectrumTableModel.getBandTableModel(i);
            for (int j = 0; j < bandTableModel.getRowCount(); ++j) {
                if (!((Boolean)bandTableModel.getValueAt(j, 0)).booleanValue()) continue;
                bandNames.add(bandTableModel.getValueAt(j, 1).toString());
            }
        }
        return bandNames.toArray(new String[bandNames.size()]);
    }

    private class TextFieldRenderer
    extends JTextField
    implements TableCellRenderer {
        private TextFieldRenderer() {
            Font font = this.getFont();
            font = new Font(font.getName(), 1, font.getSize());
            this.setFont(font);
            this.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setText(value.toString());
            return this;
        }
    }

    private class TriStateRenderer
    extends TristateCheckBox
    implements TableCellRenderer {
        private TriStateRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            int state = (Integer)value;
            this.setState(state);
            return this;
        }
    }

    private class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private BooleanRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            boolean selected = (Boolean)value;
            this.setSelected(selected);
            return this;
        }
    }

    private class ImageIconComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        private final int columnIndex;

        private ImageIconComboBoxRenderer(int columnIndex) {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
            this.columnIndex = columnIndex;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (spectraTable.getColumnModel().getColumn(this.columnIndex).getWidth() < 125) {
                this.setHorizontalAlignment(2);
            } else {
                this.setHorizontalAlignment(0);
            }
            this.setIcon((ImageIcon)value);
            return this;
        }
    }

    private static class SpectrumScrollPane
    extends JScrollPane {
        public SpectrumScrollPane(JTable table) {
            super(table);
        }

        @Override
        public Dimension getPreferredSize() {
            this.getViewport().setPreferredSize(this.getViewport().getView().getPreferredSize());
            return super.getPreferredSize();
        }
    }

    private class SpectrumTableComponentFactory
    implements HierarchicalTableComponentFactory {
        private SpectrumTableComponentFactory() {
        }

        public Component createChildComponent(HierarchicalTable table, Object value, int row) {
            if (value == null) {
                return new JPanel();
            }
            TableModel model = value instanceof JideTable ? ((JideTable)value).getModel() : (TableModel)value;
            SortableTable bandsTable = new SortableTable(model);
            AutoFilterTableHeader bandsHeader = new AutoFilterTableHeader((JTable)bandsTable);
            bandsTable.setTableHeader((JTableHeader)bandsHeader);
            TableColumn selectionColumn = bandsTable.getColumnModel().getColumn(0);
            JCheckBox selectionCheckBox = new JCheckBox();
            selectionColumn.setCellEditor(new DefaultCellEditor(selectionCheckBox));
            selectionColumn.setMinWidth(20);
            selectionColumn.setMaxWidth(20);
            BooleanRenderer booleanRenderer = new BooleanRenderer();
            selectionColumn.setCellRenderer(booleanRenderer);
            TableColumn wavelengthColumn = bandsTable.getColumnModel().getColumn(3);
            wavelengthColumn.setCellRenderer(new DecimalTableCellRenderer(new DecimalFormat("###0.0##")));
            TableColumn bandwidthColumn = bandsTable.getColumnModel().getColumn(4);
            bandwidthColumn.setCellRenderer(new DecimalTableCellRenderer(new DecimalFormat("###0.0##")));
            SpectrumChooser.this.rowToBandsTable.put(row, bandsTable);
            SpectrumScrollPane jScrollPane = new SpectrumScrollPane((JTable)bandsTable);
            return new TreeLikeHierarchicalPanel((Component)jScrollPane);
        }

        public void destroyChildComponent(HierarchicalTable table, Component component, int row) {
        }
    }

    private static class BandTableModel
    extends DefaultTableModel {
        private BandTableModel(Object[][] spectrumData, String[] bandColumns) {
            super(spectrumData, bandColumns);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }
    }

    private class SpectrumTableModel
    extends DefaultTableModel
    implements HierarchicalTableModel {
        private final Class[] COLUMN_CLASSES;
        private final String[] bandColumns;

        private SpectrumTableModel() {
            super(new String[]{"", "Spectrum name", "Unit", "Line style", "Symbol", "Symbol size"}, 0);
            this.COLUMN_CLASSES = new Class[]{Boolean.class, String.class, String.class, ImageIcon.class, ImageIcon.class, Integer.class};
            this.bandColumns = new String[]{"", "Band name", "Band description", "Spectral wavelength (nm)", "Spectral bandwidth (nm)", "Unit"};
            for (DisplayableSpectrum spectrum : SpectrumChooser.this.spectra) {
                if (!spectrum.hasBands()) continue;
                this.addRow(spectrum);
            }
        }

        public Object getChildValueAt(final int row) {
            DisplayableSpectrum spectrum = SpectrumChooser.this.spectra[row];
            if (SpectrumChooser.this.rowToBandsTable.containsKey(row)) {
                return SpectrumChooser.this.rowToBandsTable.get(row);
            }
            Band[] spectralBands = spectrum.getSpectralBands();
            Object[][] spectrumData = new Object[spectralBands.length][this.bandColumns.length];
            for (int i = 0; i < spectralBands.length; ++i) {
                Band spectralBand = spectralBands[i];
                boolean selected = spectrum.isBandSelected(i) && spectrum.isSelected();
                spectrumData[i][0] = selected;
                spectrumData[i][1] = spectralBand.getName();
                spectrumData[i][2] = spectralBand.getDescription();
                spectrumData[i][3] = Float.valueOf(spectralBand.getSpectralWavelength());
                spectrumData[i][4] = Float.valueOf(spectralBand.getSpectralBandwidth());
                spectrumData[i][5] = spectralBand.getUnit();
            }
            final BandTableModel bandTableModel = new BandTableModel(spectrumData, this.bandColumns);
            bandTableModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    e.getSource();
                    if (e.getColumn() == 0) {
                        DisplayableSpectrum spectrum = SpectrumChooser.this.spectra[row];
                        int bandRow = e.getFirstRow();
                        Boolean selected = (Boolean)bandTableModel.getValueAt(bandRow, e.getColumn());
                        spectrum.setBandSelected(bandRow, selected);
                        if (!selectionChangeLock) {
                            selectionChangeLock = true;
                            selectionAdmin.setBandSelected(row, bandRow, selected);
                            selectionAdmin.updateSpectrumSelectionState(row, selectionAdmin.getState(row));
                            spectraTable.getModel().setValueAt(selectionAdmin.getState(row), row, 0);
                            spectrum.setSelected(selectionAdmin.isSpectrumSelected(row));
                            selectionChangeLock = false;
                        }
                    }
                }
            });
            return bandTableModel;
        }

        private BandTableModel getBandTableModel(int row) {
            Object spectrumTableModelChild = this.getChildValueAt(row);
            if (spectrumTableModelChild instanceof BandTableModel) {
                return (BandTableModel)spectrumTableModelChild;
            }
            return (BandTableModel)TableModelWrapperUtils.getActualTableModel((TableModel)((JTable)spectrumTableModelChild).getModel());
        }

        private void addRow(DisplayableSpectrum spectrum) {
            ImageIcon strokeIcon = spectrum.isRemainingBandsSpectrum() ? new ImageIcon() : SpectrumStrokeProvider.getStrokeIcon(spectrum.getLineStyle());
            ImageIcon shapeIcon = SpectrumShapeProvider.getShapeIcon(spectrum.getSymbolIndex());
            selectionAdmin.evaluateSpectrumSelections(spectrum);
            super.addRow(new Object[]{selectionAdmin.getState(this.getRowCount()), spectrum.getName(), spectrum.getUnit(), strokeIcon, shapeIcon, spectrum.getSymbolSize()});
        }

        public boolean hasChild(int row) {
            return true;
        }

        public boolean isHierarchical(int row) {
            return true;
        }

        public boolean isExpandable(int row) {
            return true;
        }

        public Class getColumnClass(int columnIndex) {
            return this.COLUMN_CLASSES[columnIndex];
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return !(column == 3 && SpectrumChooser.this.spectra[row].isRemainingBandsSpectrum() || column == 1 || column == 2 || column == 5 && this.getValueAt(row, 5).toString().equals(""));
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (column == 0 && !selectionChangeLock) {
                selectionChangeLock = true;
                selectionAdmin.updateSpectrumSelectionState(row, (Integer)aValue);
                aValue = selectionAdmin.getState(row);
                this.updateBandsTable(row);
                SpectrumChooser.this.spectra[row].setSelected(selectionAdmin.isSpectrumSelected(row));
                this.fireTableCellUpdated(row, column);
                selectionChangeLock = false;
            } else if (column == 3) {
                SpectrumChooser.this.spectra[row].setLineStyle(SpectrumStrokeProvider.getStroke((ImageIcon)aValue));
            } else if (column == 4) {
                int shapeIndex = SpectrumShapeProvider.getShape((ImageIcon)aValue);
                SpectrumChooser.this.spectra[row].setSymbolIndex(shapeIndex);
                if (shapeIndex == 0) {
                    this.setValueAt("", row, 5);
                } else {
                    this.setValueAt(SpectrumChooser.this.spectra[row].getSymbolSize(), row, 5);
                }
            } else if (column == 5 && !aValue.toString().equals("")) {
                SpectrumChooser.this.spectra[row].setSymbolSize(Integer.parseInt(aValue.toString()));
            }
            super.setValueAt(aValue, row, column);
        }

        private void updateBandsTable(int row) {
            if (SpectrumChooser.this.rowToBandsTable.containsKey(row)) {
                SortableTable bandsTable = (SortableTable)SpectrumChooser.this.rowToBandsTable.get(row);
                TableModel tableModel = bandsTable.getModel();
                for (int i = 0; i < tableModel.getRowCount(); ++i) {
                    tableModel.setValueAt(selectionAdmin.isBandSelected(row, i), i, 0);
                }
            } else {
                for (int i = 0; i < SpectrumChooser.this.spectra[row].getSpectralBands().length; ++i) {
                    SpectrumChooser.this.spectra[row].setBandSelected(i, selectionAdmin.isBandSelected(row, i));
                }
            }
        }
    }
}

