/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product.spectrum;

import com.jidesoft.list.FilterableListModel;
import com.jidesoft.list.QuickListFilterField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.ui.GridBagUtils;
import org.esa.beam.framework.ui.ModalDialog;
import org.esa.beam.framework.ui.UIUtils;
import org.esa.beam.framework.ui.product.spectrum.DisplayableSpectrum;
import org.esa.beam.framework.ui.product.spectrum.Spectrum;
import org.esa.beam.framework.ui.product.spectrum.SpectrumBand;
import org.esa.beam.framework.ui.tool.ToolButtonFactory;
import org.esa.beam.util.ArrayUtils;
import org.esa.beam.util.StringUtils;

public class SpectrumEditor
extends ModalDialog {
    private JList availableBandList;
    private JList selectedBandList;
    private SpectrumListModel availableSpectraListModel;
    private SpectrumListModel selectedSpectraListModel;
    private JTextField patternField;
    private Spectrum spectrum;
    private JTextField nameField;
    private JRadioButton patternButton;
    private Map<String, Band> availableBandsMap = new HashMap<String, Band>();
    private String[] alreadyDefinedSpectrumNames;

    public SpectrumEditor(Window parent, String title, String helpID, Band[] availableSpectralBands, String[] alreadyDefinedSpectrumNames) {
        this(parent, title, helpID, availableSpectralBands, null, alreadyDefinedSpectrumNames);
    }

    public SpectrumEditor(Window parent, String title, String helpID, Band[] availableSpectralBands, Spectrum spectrum, String[] alreadyDefinedSpectrumNames) {
        super(parent, title, 33, helpID);
        for (Band availableSpectralBand : availableSpectralBands) {
            this.availableBandsMap.put(this.createBandDisplayName(availableSpectralBand), availableSpectralBand);
        }
        this.spectrum = spectrum;
        this.alreadyDefinedSpectrumNames = alreadyDefinedSpectrumNames;
        this.initialiseSpectraListModels();
        this.initUI();
    }

    private void initialiseSpectraListModels() {
        this.availableSpectraListModel = new SpectrumListModel("<No spectral bands available>");
        this.selectedSpectraListModel = new SpectrumListModel("<No spectral bands selected>");
        Set<Map.Entry<String, Band>> availableBands = this.availableBandsMap.entrySet();
        for (Map.Entry<String, Band> availableSpectralBandEntry : availableBands) {
            if (this.isInSpectrum(availableSpectralBandEntry.getValue())) {
                this.selectedSpectraListModel.addElement(availableSpectralBandEntry.getKey());
                continue;
            }
            this.availableSpectraListModel.addElement(availableSpectralBandEntry.getKey());
        }
    }

    private void updateSpectraListModels(String pattern) {
        this.availableSpectraListModel.removeAllElements();
        this.selectedSpectraListModel.removeAllElements();
        Set<Map.Entry<String, Band>> availableBands = this.availableBandsMap.entrySet();
        for (Map.Entry<String, Band> availableSpectralBandEntry : availableBands) {
            if (StringUtils.isNotNullAndNotEmpty((String)pattern) && availableSpectralBandEntry.getValue().getName().contains(pattern)) {
                this.selectedSpectraListModel.addElement(availableSpectralBandEntry.getKey());
                continue;
            }
            this.availableSpectraListModel.addElement(availableSpectralBandEntry.getKey());
        }
        this.availableBandList.updateUI();
        this.selectedBandList.updateUI();
    }

    private boolean isInSpectrum(Band availableSpectralBand) {
        if (this.spectrum == null) {
            return false;
        }
        return ArrayUtils.isMemberOf((Object)availableSpectralBand, (Object[])this.spectrum.getSpectralBands());
    }

    private String createBandDisplayName(Band band) {
        StringBuilder builder = new StringBuilder(band.getName());
        if (!Float.isNaN(band.getSpectralWavelength())) {
            builder.append(" (").append(band.getSpectralWavelength()).append(" nm)");
        }
        return builder.toString();
    }

    @Override
    public int show() {
        this.availableSpectraListModel.removeElements(this.selectedSpectraListModel.getAllElements());
        return super.show();
    }

    private void initUI() {
        JPanel content = GridBagUtils.createPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        this.nameField = new JTextField();
        Dimension textFieldDimension = new Dimension(120, 20);
        this.nameField.setPreferredSize(textFieldDimension);
        if (this.spectrum != null) {
            this.nameField.setText(this.spectrum.getName());
        } else {
            this.nameField.setText(this.createDefaultSpectrumName());
        }
        this.patternField = new JTextField();
        this.patternField.setPreferredSize(textFieldDimension);
        this.patternField.setText("");
        this.patternField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SpectrumEditor.this.updateSpectraListModels(SpectrumEditor.this.patternField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SpectrumEditor.this.updateSpectraListModels(SpectrumEditor.this.patternField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.patternButton = new JRadioButton("Assign by name pattern");
        JRadioButton manualButton = new JRadioButton("Assign spectral bands manually");
        ButtonGroup radioGroup = new ButtonGroup();
        radioGroup.add(this.patternButton);
        radioGroup.add(manualButton);
        manualButton.setSelected(true);
        final JPanel bandAssignmentPanel = this.createBandAssignmentPanel();
        this.patternButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpectrumEditor.this.updateUIEnablement(SpectrumEditor.this.patternButton.isSelected(), bandAssignmentPanel);
            }
        });
        manualButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpectrumEditor.this.updateUIEnablement(SpectrumEditor.this.patternButton.isSelected(), bandAssignmentPanel);
            }
        });
        this.updateUIEnablement(this.patternButton.isSelected(), bandAssignmentPanel);
        GridBagUtils.addToPanel(content, new JLabel("Name:"), gbc, "gridx=0, gridy=0, anchor=NORTHWEST, fill=NONE, weightx=0.0,gridwidth=1, weighty=0.0, insets=2");
        GridBagUtils.addToPanel(content, this.nameField, gbc, "gridx=1, fill=HORIZONTAL, weightx=1.0");
        GridBagUtils.addToPanel(content, this.patternButton, gbc, "gridx=0, gridy=1, weightx=1.0, gridwidth=2");
        GridBagUtils.addToPanel(content, this.patternField, gbc, "gridy=2");
        GridBagUtils.addToPanel(content, manualButton, gbc, "gridy=3");
        GridBagUtils.addToPanel(content, bandAssignmentPanel, gbc, "gridy=4, fill=BOTH, weighty=1.0");
        content.setMinimumSize(content.getPreferredSize());
        this.setContent(content);
        content.validate();
    }

    private String createDefaultSpectrumName() {
        int spectrumNumber = 1;
        StringBuilder builder = new StringBuilder("Spectrum ");
        builder.append(spectrumNumber++);
        while (ArrayUtils.isMemberOf((Object)builder.toString(), (Object[])this.alreadyDefinedSpectrumNames)) {
            builder.delete(9, builder.length());
            builder.append(spectrumNumber++);
        }
        return builder.toString();
    }

    private void updateUIEnablement(boolean patternMode, JPanel bandAssignmentPanel) {
        Component[] bandAssignmentPanelComponents;
        this.patternField.setEnabled(patternMode);
        for (Component bandAssignmentPanelComponent : bandAssignmentPanelComponents = bandAssignmentPanel.getComponents()) {
            bandAssignmentPanelComponent.setEnabled(!patternMode);
        }
        this.availableBandList.setEnabled(!patternMode);
        this.selectedBandList.setEnabled(!patternMode);
        this.patternField.updateUI();
        bandAssignmentPanel.updateUI();
    }

    private JPanel createBandAssignmentPanel() {
        JPanel bandAssignmentPanel = GridBagUtils.createPanel();
        Set<String> availableBands = this.availableBandsMap.keySet();
        ArrayList<String> availableSpectralBandNames = new ArrayList<String>(availableBands);
        this.availableSpectraListModel = new SpectrumListModel(availableSpectralBandNames, "<No spectral bands available>");
        QuickListFilterField filterField = new QuickListFilterField((ListModel)this.availableSpectraListModel);
        filterField.setHintText("Type here to filter spectral bands");
        filterField.setWildcardEnabled(true);
        FilterableListModel listModel = filterField.getDisplayListModel();
        this.availableBandList = new JList(listModel);
        filterField.setList(this.availableBandList);
        this.availableBandList.setSelectionMode(2);
        JScrollPane availableBandsScrollPane = new JScrollPane(this.availableBandList);
        availableBandsScrollPane.setPreferredSize(new Dimension(150, 150));
        availableBandsScrollPane.setBorder(new TitledBorder("Available spectral bands:"));
        AbstractButton rightButton = this.createButton("icons/Right24.gif");
        rightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] selectedValues = SpectrumEditor.this.availableBandList.getSelectedValues();
                if (!selectedValues[0].toString().equals(SpectrumEditor.this.availableSpectraListModel.emptyMessage)) {
                    for (Object selectedValue : selectedValues) {
                        SpectrumEditor.this.selectedSpectraListModel.addElement(selectedValue.toString());
                        SpectrumEditor.this.availableSpectraListModel.removeElement(selectedValue.toString());
                        SpectrumEditor.this.availableBandList.updateUI();
                        SpectrumEditor.this.selectedBandList.updateUI();
                    }
                }
            }
        });
        AbstractButton leftButton = this.createButton("icons/Left24.gif");
        leftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] selectedValues = SpectrumEditor.this.selectedBandList.getSelectedValues();
                if (!selectedValues[0].toString().equals(SpectrumEditor.this.selectedSpectraListModel.emptyMessage)) {
                    for (Object selectedValue : selectedValues) {
                        SpectrumEditor.this.availableSpectraListModel.addElement(selectedValue.toString());
                        SpectrumEditor.this.selectedSpectraListModel.removeElement(selectedValue.toString());
                        SpectrumEditor.this.availableBandList.updateUI();
                        SpectrumEditor.this.selectedBandList.updateUI();
                    }
                }
            }
        });
        AbstractButton allRightButton = this.createButton("icons/PanelRight12.png");
        allRightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<String> allElements = SpectrumEditor.this.availableSpectraListModel.getAllElements();
                SpectrumEditor.this.selectedSpectraListModel.addElements(allElements);
                SpectrumEditor.this.availableSpectraListModel.removeAllElements();
                SpectrumEditor.this.availableBandList.updateUI();
                SpectrumEditor.this.selectedBandList.updateUI();
            }
        });
        AbstractButton allLeftButton = this.createButton("icons/PanelLeft12.png");
        allLeftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<String> allElements = SpectrumEditor.this.selectedSpectraListModel.getAllElements();
                SpectrumEditor.this.availableSpectraListModel.addElements(allElements);
                SpectrumEditor.this.selectedSpectraListModel.removeAllElements();
                SpectrumEditor.this.availableBandList.updateUI();
                SpectrumEditor.this.selectedBandList.updateUI();
            }
        });
        this.selectedBandList = new JList(this.selectedSpectraListModel);
        JScrollPane selectedBandScrollPane = new JScrollPane(this.selectedBandList);
        selectedBandScrollPane.setBorder(new TitledBorder("Selected spectral bands:"));
        this.availableBandList.setPreferredSize(new Dimension(100, 100));
        this.selectedBandList.setPreferredSize(new Dimension(100, 100));
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagUtils.addToPanel(bandAssignmentPanel, (Component)filterField, gbc, "weightx=1.0, weighty=1.0, gridx=0, gridy=0, fill=HORIZONTAL");
        GridBagUtils.addToPanel(bandAssignmentPanel, availableBandsScrollPane, gbc, "gridy=1, fill=BOTH,gridheight=5");
        GridBagUtils.addToPanel(bandAssignmentPanel, rightButton, gbc, "gridx=1,gridy=1,weightx=0,weighty=0,fill=NONE,gridheight=1");
        GridBagUtils.addToPanel(bandAssignmentPanel, leftButton, gbc, "gridy=2");
        GridBagUtils.addToPanel(bandAssignmentPanel, allRightButton, gbc, "gridy=3");
        GridBagUtils.addToPanel(bandAssignmentPanel, allLeftButton, gbc, "gridy=4");
        GridBagUtils.addVerticalFiller(bandAssignmentPanel, gbc);
        GridBagUtils.addToPanel(bandAssignmentPanel, selectedBandScrollPane, gbc, "gridx=2,gridy=1,weightx=1.0, weighty=1.0,fill=BOTH,gridheight=5");
        return bandAssignmentPanel;
    }

    private AbstractButton createButton(String iconPath) {
        return ToolButtonFactory.createButton(UIUtils.loadImageIcon(iconPath), false);
    }

    public Spectrum getSpectrum() {
        List<String> selectedElements = this.selectedSpectraListModel.getAllElements();
        SpectrumBand[] selectedBands = new SpectrumBand[selectedElements.size()];
        for (int i = 0; i < selectedBands.length; ++i) {
            selectedBands[i] = new SpectrumBand(this.availableBandsMap.get(selectedElements.get(i)), true);
        }
        return new DisplayableSpectrum(this.nameField.getName(), selectedBands, 1);
    }

    @Override
    protected boolean verifyUserInput() {
        if (StringUtils.isNullOrEmpty((String)this.nameField.getText())) {
            this.showInformationDialog("No name chosen.\nPlease assign a name to the spectrum.");
            return false;
        }
        if (ArrayUtils.isMemberOf((Object)this.nameField.getText(), (Object[])this.alreadyDefinedSpectrumNames)) {
            this.showInformationDialog("Name already assigned.\nPlease assign another name to the spectrum.");
            return false;
        }
        if (this.selectedSpectraListModel.getAllElements().size() == 0) {
            this.showInformationDialog("No bands selected.\nPlease select at least one band.");
            return false;
        }
        return true;
    }

    private class SpectrumListModel
    extends AbstractListModel {
        private final List<String> spectralBandNamesList;
        private String emptyMessage;

        SpectrumListModel(String emptyMessage) {
            this.spectralBandNamesList = new ArrayList<String>();
            this.emptyMessage = emptyMessage;
            this.insertEmptyMessageIfNecessary();
        }

        SpectrumListModel(List<String> spectralBandNames, String emptyMessage) {
            Collections.sort(spectralBandNames);
            this.spectralBandNamesList = new ArrayList<String>(spectralBandNames);
            this.emptyMessage = emptyMessage;
            this.insertEmptyMessageIfNecessary();
        }

        @Override
        public String getElementAt(int index) {
            return this.spectralBandNamesList.get(index);
        }

        @Override
        public int getSize() {
            return this.spectralBandNamesList.size();
        }

        public void addElement(String spectralBandName) {
            this.removeEmptyMessageIfNecessary();
            this.spectralBandNamesList.add(spectralBandName);
            Collections.sort(this.spectralBandNamesList);
        }

        public void addElements(List<String> spectralBandNames) {
            this.removeEmptyMessageIfNecessary();
            this.spectralBandNamesList.addAll(spectralBandNames);
            Collections.sort(this.spectralBandNamesList);
        }

        public List<String> getAllElements() {
            if (this.spectralBandNamesList.size() == 1 && this.spectralBandNamesList.get(0).equals(this.emptyMessage)) {
                return new ArrayList<String>();
            }
            return this.spectralBandNamesList;
        }

        public void removeElement(String spectralBandName) {
            this.spectralBandNamesList.remove(spectralBandName);
            Collections.sort(this.spectralBandNamesList);
            this.insertEmptyMessageIfNecessary();
        }

        public void removeElements(List<String> spectralBandNames) {
            this.spectralBandNamesList.removeAll(spectralBandNames);
            this.insertEmptyMessageIfNecessary();
        }

        public void removeAllElements() {
            this.spectralBandNamesList.clear();
            this.insertEmptyMessageIfNecessary();
        }

        private void insertEmptyMessageIfNecessary() {
            if (this.spectralBandNamesList.isEmpty()) {
                this.spectralBandNamesList.add(this.emptyMessage);
            }
        }

        private void removeEmptyMessageIfNecessary() {
            if (this.spectralBandNamesList.size() == 1 && this.spectralBandNamesList.get(0).equals(this.emptyMessage)) {
                this.spectralBandNamesList.clear();
            }
        }
    }
}

