/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product.tree;

import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.ui.product.tree.AbstractTN;

class IdentificationTN
extends AbstractTN {
    private MetadataElement metadataElement;

    IdentificationTN(String name, MetadataElement element, AbstractTN parent) {
        super(name, element, parent);
        MetadataElement absRoot = element.getElement("Abstracted_Metadata");
        this.metadataElement = absRoot != null ? IdentificationTN.createIdentificationNodes(element, absRoot) : element;
        this.metadataElement.setOwner((ProductNode)element.getProduct());
    }

    public MetadataElement getMetadataElement() {
        return this.metadataElement;
    }

    @Override
    public AbstractTN getChildAt(int index) {
        MetadataElement elem = this.metadataElement.getElementAt(index);
        return new IdentificationTN(elem.getName(), elem, (AbstractTN)this);
    }

    @Override
    public int getChildCount() {
        return this.metadataElement.getNumElements();
    }

    @Override
    protected int getIndex(AbstractTN child) {
        IdentificationTN metadataNode = (IdentificationTN)child;
        MetadataElement[] metadataElements = this.metadataElement.getElements();
        int metadataElementsLength = metadataElements.length;
        for (int i = 0; i < metadataElementsLength; ++i) {
            MetadataElement element = metadataElements[i];
            if (element != metadataNode.getMetadataElement()) continue;
            return i;
        }
        return -1;
    }

    private static MetadataElement createIdentificationNodes(MetadataElement rootElement, MetadataElement absRoot) {
        MetadataElement identNode = new MetadataElement("Identification");
        IdentificationTN.addIDNode(absRoot, identNode, "Mission", "MISSION");
        IdentificationTN.addIDNode(absRoot, identNode, "Type", "PRODUCT_TYPE");
        IdentificationTN.addIDNode(absRoot, identNode, "Acquisition", "first_line_time");
        IdentificationTN.addIDNode(absRoot, identNode, "Pass", "PASS");
        IdentificationTN.addIDNode(absRoot, identNode, "Track", "REL_ORBIT");
        IdentificationTN.addIDNode(absRoot, identNode, "Orbit", "ABS_ORBIT");
        MetadataElement slaveRoot = rootElement.getElement("Slave Metadata");
        if (slaveRoot != null) {
            for (MetadataElement slvElem : slaveRoot.getElements()) {
                MetadataElement slvNode = new MetadataElement(slvElem.getName());
                IdentificationTN.addIDNode(slvElem, slvNode, "Mission", "MISSION");
                IdentificationTN.addIDNode(slvElem, slvNode, "Type", "PRODUCT_TYPE");
                IdentificationTN.addIDNode(slvElem, slvNode, "Acquisition", "first_line_time");
                IdentificationTN.addIDNode(slvElem, slvNode, "Pass", "PASS");
                IdentificationTN.addIDNode(slvElem, slvNode, "Track", "REL_ORBIT");
                IdentificationTN.addIDNode(slvElem, slvNode, "Orbit", "ABS_ORBIT");
                identNode.addElement(slvNode);
            }
        }
        return identNode;
    }

    private static void addIDNode(MetadataElement absRoot, MetadataElement identNode, String title, String tag) {
        MetadataAttribute attrib = absRoot.getAttribute(tag);
        if (attrib == null) {
            return;
        }
        String value = title + ": " + attrib.getData().getElemString();
        MetadataElement newAttrib = new MetadataElement(value);
        identNode.addElement(newAttrib);
    }
}

