/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product.tree;

import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductNodeGroup;
import org.esa.beam.framework.ui.product.tree.AbstractTN;

class ProductNodeTN
extends AbstractTN {
    private final ProductNode productNode;

    ProductNodeTN(String name, ProductNode productNode, AbstractTN parent) {
        super(name, productNode, parent);
        this.productNode = productNode;
    }

    public ProductNode getProductNode() {
        return this.productNode;
    }

    @Override
    public AbstractTN getChildAt(int index) {
        if (this.productNode instanceof ProductNodeGroup) {
            ProductNodeGroup nodeGroup = (ProductNodeGroup)this.productNode;
            ProductNode node = nodeGroup.get(index);
            return new ProductNodeTN(node.getName(), node, (AbstractTN)this);
        }
        throw new IndexOutOfBoundsException("node has no children");
    }

    @Override
    public int getChildCount() {
        if (this.productNode instanceof ProductNodeGroup) {
            ProductNodeGroup nodeGroup = (ProductNodeGroup)this.productNode;
            return nodeGroup.getNodeCount();
        }
        return 0;
    }

    @Override
    protected int getIndex(AbstractTN child) {
        if (this.productNode instanceof ProductNodeGroup) {
            ProductNodeGroup nodeGroup = (ProductNodeGroup)this.productNode;
            ProductNodeTN childNodeTN = (ProductNodeTN)child;
            return nodeGroup.indexOf(childNodeTN.getProductNode().getName());
        }
        throw new IndexOutOfBoundsException("node has no children");
    }
}

