/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product.tree;

import java.util.HashMap;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductNodeGroup;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.VectorDataNode;
import org.esa.beam.framework.ui.product.tree.AbstractTN;
import org.esa.beam.framework.ui.product.tree.IdentificationTN;
import org.esa.beam.framework.ui.product.tree.MetadataTN;
import org.esa.beam.framework.ui.product.tree.ProductNodeTN;

class ProductTN
extends AbstractTN {
    private static final String IDENTIFICATION = "Identification";
    private static final String METADATA = "Metadata";
    private static final String BANDS = "Bands";
    private static final String VECTOR_DATA = "Vector data";
    private static final String TIE_POINT_GRIDS = "Tie-point grids";
    private static final String FLAG_CODINGS = "Flag codings";
    private static final String INDEX_CODINGS = "Index codings";
    private Product product;

    ProductTN(Product product, AbstractTN parent) {
        super(product.getDisplayName(), product, parent);
        this.product = product;
    }

    public Product getProduct() {
        return this.product;
    }

    @Override
    public AbstractTN getChildAt(int index) {
        int childIndex = -1;
        if (ProductTN.hasIdentification(this.product) && ++childIndex == index) {
            return new IdentificationTN(IDENTIFICATION, this.product.getMetadataRoot(), (AbstractTN)this);
        }
        if (ProductTN.hasMetadata(this.product) && ++childIndex == index) {
            return new MetadataTN(METADATA, this.product.getMetadataRoot(), (AbstractTN)this);
        }
        if (ProductTN.hasFlagCoding(this.product) && ++childIndex == index) {
            return new ProductNodeTN(FLAG_CODINGS, (ProductNode)this.product.getFlagCodingGroup(), (AbstractTN)this);
        }
        if (ProductTN.hasIndexCoding(this.product) && ++childIndex == index) {
            return new ProductNodeTN(INDEX_CODINGS, (ProductNode)this.product.getIndexCodingGroup(), (AbstractTN)this);
        }
        if (ProductTN.hasTiePoints(this.product) && ++childIndex == index) {
            Product.AutoGrouping autoGrouping = this.product.getAutoGrouping();
            if (autoGrouping != null) {
                return new ProductNodeTN(TIE_POINT_GRIDS, ProductTN.group((ProductNodeGroup<? extends RasterDataNode>)this.product.getTiePointGridGroup(), autoGrouping), (AbstractTN)this);
            }
            return new ProductNodeTN(TIE_POINT_GRIDS, (ProductNode)this.product.getTiePointGridGroup(), (AbstractTN)this);
        }
        if (ProductTN.mustShowVectorData(this.product) && ++childIndex == index) {
            return new ProductNodeTN(VECTOR_DATA, (ProductNode)this.product.getVectorDataGroup(), (AbstractTN)this);
        }
        if (ProductTN.hasBands(this.product) && ++childIndex == index) {
            Product.AutoGrouping autoGrouping = this.product.getAutoGrouping();
            if (autoGrouping != null) {
                return new ProductNodeTN(BANDS, ProductTN.group((ProductNodeGroup<? extends RasterDataNode>)this.product.getBandGroup(), autoGrouping), (AbstractTN)this);
            }
            return new ProductNodeTN(BANDS, (ProductNode)this.product.getBandGroup(), (AbstractTN)this);
        }
        throw new IndexOutOfBoundsException(String.format("No child for index <%d>.", index));
    }

    private static ProductNode group(ProductNodeGroup<? extends RasterDataNode> bandGroup, Product.AutoGrouping autoGrouping) {
        HashMap<String, ProductNodeGroup> subGroupMap = new HashMap<String, ProductNodeGroup>();
        ProductNodeGroup newGroup = new ProductNodeGroup(null, bandGroup.getName(), false);
        newGroup.setDescription(bandGroup.getDescription());
        int count = bandGroup.getNodeCount();
        for (int i = 0; i < count; ++i) {
            RasterDataNode band = (RasterDataNode)bandGroup.get(i);
            String bandName = band.getName();
            int groupPathIndex = autoGrouping.indexOf(bandName);
            if (groupPathIndex >= 0) {
                String subGroupName = ProductTN.createGroupName((String[])autoGrouping.get(groupPathIndex));
                ProductNodeGroup subGroup = (ProductNodeGroup)subGroupMap.get(subGroupName);
                if (subGroup == null) {
                    subGroup = new ProductNodeGroup(null, subGroupName, false);
                    subGroupMap.put(subGroupName, subGroup);
                    newGroup.add((ProductNode)subGroup);
                }
                subGroup.add((ProductNode)band);
                continue;
            }
            newGroup.add((ProductNode)band);
        }
        return newGroup;
    }

    private static String createGroupName(String[] groupPath) {
        if (groupPath.length == 1) {
            return groupPath[0];
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < groupPath.length; ++i) {
            if (i > 0) {
                sb.append('_');
            }
            sb.append(groupPath[i]);
        }
        return sb.toString();
    }

    @Override
    public int getChildCount() {
        int childCount = 0;
        if (ProductTN.hasIdentification(this.product)) {
            ++childCount;
        }
        if (ProductTN.hasMetadata(this.product)) {
            ++childCount;
        }
        if (ProductTN.hasFlagCoding(this.product)) {
            ++childCount;
        }
        if (ProductTN.hasIndexCoding(this.product)) {
            ++childCount;
        }
        if (ProductTN.hasTiePoints(this.product)) {
            ++childCount;
        }
        if (ProductTN.mustShowVectorData(this.product)) {
            ++childCount;
        }
        if (ProductTN.hasBands(this.product)) {
            ++childCount;
        }
        return childCount;
    }

    @Override
    protected int getIndex(AbstractTN child) {
        int childIndex = -1;
        if (ProductTN.hasIdentification(this.product)) {
            ++childIndex;
            if (child.getName().equals(IDENTIFICATION)) {
                return childIndex;
            }
        }
        if (ProductTN.hasMetadata(this.product)) {
            ++childIndex;
            if (child.getName().equals(METADATA)) {
                return childIndex;
            }
        }
        if (ProductTN.hasFlagCoding(this.product)) {
            ++childIndex;
            if (child.getName().equals(FLAG_CODINGS)) {
                return childIndex;
            }
        }
        if (ProductTN.hasIndexCoding(this.product)) {
            ++childIndex;
            if (child.getName().equals(INDEX_CODINGS)) {
                return childIndex;
            }
        }
        if (ProductTN.hasTiePoints(this.product)) {
            ++childIndex;
            if (child.getName().equals(TIE_POINT_GRIDS)) {
                return childIndex;
            }
        }
        if (ProductTN.mustShowVectorData(this.product)) {
            ++childIndex;
            if (child.getName().equals(VECTOR_DATA)) {
                return childIndex;
            }
        }
        if (ProductTN.hasBands(this.product)) {
            ++childIndex;
            if (child.getName().equals(BANDS)) {
                return childIndex;
            }
        }
        return childIndex;
    }

    private static boolean hasBands(Product product) {
        return product.getBandGroup().getNodeCount() > 0;
    }

    private static boolean hasTiePoints(Product product) {
        return product.getTiePointGridGroup().getNodeCount() > 0;
    }

    private static boolean mustShowVectorData(Product product) {
        ProductNodeGroup vectorNodeGroup = product.getVectorDataGroup();
        VectorDataNode gcpVectorDataNode = product.getGcpGroup().getVectorDataNode();
        VectorDataNode pinVectorDataNode = product.getPinGroup().getVectorDataNode();
        for (int i = 0; i < vectorNodeGroup.getNodeCount(); ++i) {
            boolean isPinOrGcpNode;
            VectorDataNode vectorDataNode = (VectorDataNode)vectorNodeGroup.get(i);
            boolean bl = isPinOrGcpNode = vectorDataNode.equals(gcpVectorDataNode) || vectorDataNode.equals(pinVectorDataNode);
            if (isPinOrGcpNode) {
                if (vectorDataNode.getPlacemarkGroup().getNodeCount() <= 0) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private static boolean hasIndexCoding(Product product) {
        return product.getIndexCodingGroup().getNodeCount() > 0;
    }

    private static boolean hasFlagCoding(Product product) {
        return product.getFlagCodingGroup().getNodeCount() > 0;
    }

    private static boolean hasMetadata(Product product) {
        return product.getMetadataRoot() != null && (product.getMetadataRoot().getNumElements() > 0 || product.getMetadataRoot().getNumAttributes() > 0);
    }

    private static boolean hasIdentification(Product product) {
        return product.getMetadataRoot() != null && product.getMetadataRoot().getElement("Abstracted_Metadata") != null;
    }
}

