/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product.tree;

import java.util.ArrayList;
import java.util.Collections;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductManager;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductNodeEvent;
import org.esa.beam.framework.datamodel.ProductNodeListener;
import org.esa.beam.framework.datamodel.ProductNodeListenerAdapter;
import org.esa.beam.framework.datamodel.VectorDataNode;
import org.esa.beam.framework.ui.product.tree.AbstractTN;
import org.esa.beam.framework.ui.product.tree.ProductManagerTN;
import org.esa.beam.framework.ui.product.tree.TreeNodeEnumeration;

public class ProductTreeModel
implements TreeModel {
    private final ProductManagerTN rootTN;
    private ProductNodeListener productNodeListener;
    private ProductManager productManager;
    private final EventListenerList treeModelListeners;

    public ProductTreeModel(ProductManager manager) {
        this.productManager = manager;
        this.rootTN = new ProductManagerTN(this.productManager);
        this.productNodeListener = new ProductListener();
        this.productManager.addListener((ProductManager.Listener)new ProductManagerListener());
        this.treeModelListeners = new EventListenerList();
    }

    public ProductManager getProductManager() {
        return this.productManager;
    }

    @Override
    public AbstractTN getChild(Object parent, int index) {
        return ((AbstractTN)parent).getChildAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((AbstractTN)parent).getChildCount();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return ((AbstractTN)parent).getIndex((AbstractTN)child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.remove(TreeModelListener.class, l);
    }

    @Override
    public AbstractTN getRoot() {
        return this.rootTN;
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((AbstractTN)node).getChildCount() == 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        this.fireTreeNodeChanged(path);
    }

    protected void fireTreeNodeInserted(TreePath treePath) {
        TreeModelListener[] listeners;
        TreeModelEvent event = new TreeModelEvent((Object)this, treePath);
        for (TreeModelListener treeModelListener : listeners = (TreeModelListener[])this.treeModelListeners.getListeners(TreeModelListener.class)) {
            treeModelListener.treeNodesInserted(event);
        }
    }

    protected void fireTreeNodeRemoved(TreePath treePath) {
        TreeModelListener[] listeners;
        TreeModelEvent event = new TreeModelEvent((Object)this, treePath);
        for (TreeModelListener treeModelListener : listeners = (TreeModelListener[])this.treeModelListeners.getListeners(TreeModelListener.class)) {
            treeModelListener.treeNodesRemoved(event);
        }
    }

    protected void fireTreeNodeChanged(TreePath treePath) {
        TreeModelListener[] listeners;
        TreeModelEvent event = new TreeModelEvent((Object)this, treePath);
        for (TreeModelListener treeModelListener : listeners = (TreeModelListener[])this.treeModelListeners.getListeners(TreeModelListener.class)) {
            treeModelListener.treeNodesChanged(event);
        }
    }

    public TreePath getTreePath(Object nodeContent) {
        TreeNodeEnumeration.Postorder enumeration = new TreeNodeEnumeration.Postorder(this.getRoot());
        while (enumeration.hasMoreElements()) {
            AbstractTN childNode = (AbstractTN)enumeration.nextElement();
            if (childNode.getContent() != nodeContent) continue;
            ArrayList<AbstractTN> pathList = new ArrayList<AbstractTN>();
            for (AbstractTN actualNode = childNode; actualNode != null; actualNode = actualNode.getParent()) {
                pathList.add(actualNode);
            }
            Collections.reverse(pathList);
            return new TreePath(pathList.toArray());
        }
        return null;
    }

    private class ProductListener
    extends ProductNodeListenerAdapter {
        private ProductListener() {
        }

        public void nodeChanged(ProductNodeEvent event) {
            TreePath path;
            ProductNode sourceNode = event.getSourceNode();
            if ((sourceNode instanceof Product || sourceNode instanceof VectorDataNode) && (path = ProductTreeModel.this.getTreePath(sourceNode)) != null) {
                ProductTreeModel.this.fireTreeNodeChanged(path);
            }
        }

        public void nodeDataChanged(ProductNodeEvent event) {
            TreePath path = ProductTreeModel.this.getTreePath(event.getSourceNode());
            if (path != null) {
                ProductTreeModel.this.fireTreeNodeChanged(path);
            }
        }

        public void nodeAdded(ProductNodeEvent event) {
            TreePath path = ProductTreeModel.this.getTreePath(event.getSourceNode());
            if (path != null) {
                ProductTreeModel.this.fireTreeNodeInserted(path);
            }
        }

        public void nodeRemoved(ProductNodeEvent event) {
            TreePath path = ProductTreeModel.this.getTreePath(event.getSourceNode().getProduct());
            if (path != null) {
                ProductTreeModel.this.fireTreeNodeRemoved(path);
            }
        }
    }

    private class ProductManagerListener
    implements ProductManager.Listener {
        private ProductManagerListener() {
        }

        public void productAdded(ProductManager.Event event) {
            Product product = event.getProduct();
            ProductTreeModel.this.fireTreeNodeInserted(ProductTreeModel.this.getTreePath(product));
            product.addProductNodeListener(ProductTreeModel.this.productNodeListener);
        }

        public void productRemoved(ProductManager.Event event) {
            Product product = event.getProduct();
            product.removeProductNodeListener(ProductTreeModel.this.productNodeListener);
            ProductTreeModel.this.fireTreeNodeRemoved(ProductTreeModel.this.getTreePath(ProductTreeModel.this.getProductManager()));
        }
    }
}

