/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product.tree;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.tree.TreeNode;

final class TreeNodeEnumeration {
    public static final Enumeration<TreeNode> EMPTY_ENUMERATION = new EmptyEnumeration();

    private TreeNodeEnumeration() {
    }

    private static class EmptyEnumeration
    implements Enumeration<TreeNode> {
        private EmptyEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public TreeNode nextElement() {
            throw new NoSuchElementException("No more elements");
        }
    }

    public static final class Postorder
    implements Enumeration<TreeNode> {
        protected TreeNode root;
        protected Enumeration<TreeNode> children;
        protected Enumeration<TreeNode> subtree;

        public Postorder(TreeNode rootNode) {
            this.root = rootNode;
            this.children = this.root.children();
            this.subtree = EMPTY_ENUMERATION;
        }

        @Override
        public boolean hasMoreElements() {
            return this.root != null;
        }

        @Override
        public TreeNode nextElement() {
            TreeNode retval;
            if (this.subtree.hasMoreElements()) {
                retval = this.subtree.nextElement();
            } else if (this.children.hasMoreElements()) {
                this.subtree = new Postorder(this.children.nextElement());
                retval = this.subtree.nextElement();
            } else {
                retval = this.root;
                this.root = null;
            }
            return retval;
        }
    }
}

