/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.unmixing.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.framework.ui.diagram.DiagramCanvas;
import org.esa.beam.framework.ui.tool.ToolButtonFactory;
import org.esa.beam.unmixing.ui.EndmemberFormModel;

class EndmemberForm
extends JPanel {
    EndmemberFormModel formModel;
    JList endmemberList;
    DiagramCanvas diagramCanvas;
    JButton addButton;
    JButton removeButton;
    JButton exportButton;

    public EndmemberForm(AppContext appContext) {
        this.formModel = new EndmemberFormModel(appContext);
        this.initComponents();
    }

    public EndmemberFormModel getFormModel() {
        return this.formModel;
    }

    private void initComponents() {
        this.endmemberList = new JList();
        this.endmemberList.setModel(this.formModel.getEndmemberListModel());
        this.endmemberList.setSelectionModel(this.formModel.getEndmemberListSelectionModel());
        this.endmemberList.setPreferredSize(new Dimension(80, 160));
        this.diagramCanvas = new DiagramCanvas();
        this.diagramCanvas.setDiagram(this.formModel.getEndmemberDiagram());
        this.formModel.getPropertyChangeSupport().addPropertyChangeListener("selectedEndmemberIndex", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EndmemberForm.this.diagramCanvas.repaint();
            }
        });
        AbstractButton addButton = ToolButtonFactory.createButton((Action)this.formModel.getAddAction(), (boolean)false);
        AbstractButton removeButton = ToolButtonFactory.createButton((Action)this.formModel.getRemoveAction(), (boolean)false);
        AbstractButton clearButton = ToolButtonFactory.createButton((Action)this.formModel.getClearAction(), (boolean)false);
        AbstractButton exportButton = ToolButtonFactory.createButton((Action)this.formModel.getExportAction(), (boolean)false);
        GridBagLayout gbl = new GridBagLayout();
        JPanel actionPanel = new JPanel(gbl);
        actionPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 0, 3));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.ipady = 2;
        gbc.gridy = 0;
        actionPanel.add((Component)addButton, gbc);
        ++gbc.gridy;
        actionPanel.add((Component)removeButton, gbc);
        ++gbc.gridy;
        actionPanel.add((Component)clearButton, gbc);
        ++gbc.gridy;
        actionPanel.add((Component)exportButton, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        actionPanel.add((Component)new JLabel(), gbc);
        Color color = actionPanel.getBackground();
        float[] rgbColors = new float[3];
        color.getRGBColorComponents(rgbColors);
        float factor = 0.9f;
        actionPanel.setBackground(new Color(rgbColors[0] * 0.9f, rgbColors[1] * 0.9f, rgbColors[2] * 0.9f));
        JPanel endmemberSelectionPanel = new JPanel(new BorderLayout());
        endmemberSelectionPanel.add((Component)new JScrollPane(this.endmemberList), "Center");
        endmemberSelectionPanel.add((Component)actionPanel, "West");
        JPanel endmemberPreviewPanel = new JPanel(new BorderLayout());
        endmemberPreviewPanel.add((Component)this.diagramCanvas, "Center");
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setLeftComponent(endmemberSelectionPanel);
        splitPane.setRightComponent(endmemberPreviewPanel);
        splitPane.setBorder(BorderFactory.createEmptyBorder());
        splitPane.setUI(this.createPlainDividerSplitPaneUI());
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
    }

    private BasicSplitPaneUI createPlainDividerSplitPaneUI() {
        return new BasicSplitPaneUI(){

            @Override
            public BasicSplitPaneDivider createDefaultDivider() {
                return new BasicSplitPaneDivider(this){

                    @Override
                    public void paint(Graphics g) {
                    }
                };
            }
        };
    }
}

